package com.namasoft.common.utilities;

import java.util.ArrayList;
import java.util.List;

public class ReferenceHashMap<K, V>
{
	private List<K> keys = new ArrayList<K>();
	private List<V> values = new ArrayList<V>();

	public void put(K k, V v)
	{
		int index = getKeyIndex(k);
		if (index >= 0)
		{
			values.set(index, v);
		}
		else
		{
			keys.add(k);
			values.add(v);
		}
	}

	public V get(K k)
	{
		int index = getKeyIndex(k);
		if (index >= 0)
			return values.get(index);
		return null;
	}

	private int getKeyIndex(K k)
	{
		for (int i = 0; i < keys.size(); i++)
			if (keys.get(i) == k)
				return i;
		return -1;
	}

	public void clear()
	{
		keys.clear();
		values.clear();
	}
}