package com.namasoft.common.utilities;

import java.io.Serializable;
import java.util.List;
import java.util.Map.Entry;

public class SimpleEntry<K, V> implements Entry<K, V>, Serializable
{
	private static final long serialVersionUID = 4052390067508552701L;
	private K key;
	private V value;

	public SimpleEntry()
	{
	}

	public SimpleEntry(K key, V value)
	{
		this.key = key;
		this.value = value;
	}

	@Override
	public K getKey()
	{
		return key;
	}

	@Override
	public V getValue()
	{
		return value;
	}

	@Override
	public V setValue(V value)
	{
		V oldValue = this.value;
		this.value = value;
		return oldValue;
	}

	public void setKey(K key)
	{
		this.key = key;
	}

	public static <K, V> V get(K key, List<SimpleEntry<K, V>> list)
	{
		for (SimpleEntry<K, V> simpleEntry : list)
		{
			if (ObjectChecker.areEqual(key, simpleEntry.getKey()))
				return simpleEntry.getValue();
		}
		return null;
	}

	public static <K, V> SimpleEntry<K, V> getEntry(K key, List<SimpleEntry<K, V>> list)
	{
		int index = getIndex(key, list);
		if (index < 0)
			return null;
		return list.get(index);
	}

	public static <K, V> int getIndex(K key, List<SimpleEntry<K, V>> list)
	{
		for (int i = 0; i < list.size(); i++)
		{
			SimpleEntry<K, V> simpleEntry = list.get(i);
			if (ObjectChecker.areEqual(key, simpleEntry.getKey()))
				return i;
		}
		return -1;
	}

	@Override
	public String toString()
	{
		return key + "=" + value;
	}

	public static <K, V> int getIndexByValue(V value, List<SimpleEntry<K, V>> list)
	{
		for (int i = 0; i < list.size(); i++)
		{
			SimpleEntry<K, V> simpleEntry = list.get(i);
			if (ObjectChecker.areEqual(value, simpleEntry.getValue()))
				return i;
		}
		return -1;
	}

	public static <K, V> SimpleEntry<K, V> e(K k, V v)
	{
		return new SimpleEntry<K, V>(k, v);
	}

	public static SimpleEntry<Object, Object> eo(Object k, Object v)
	{
		return new SimpleEntry<Object, Object>(k, v);
	}
}
