package com.namasoft.common.utils;

import com.namasoft.common.utilities.Base64;
import com.namasoft.common.utilities.ObjectChecker;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

public class CryptoUtils
{
	private static final String ALGORITHM = "AES";
	private static final String TRANSFORMATION = "AES";
	private static final byte[] key = new byte[] { 1, -55, 12, 66, 32, 88, 10, 12, 127, -116, 118, 75, 96, -32, 84, 75 };
	public static final String prefix = "$EN$:-";

	public static String encryptAndAddPrefix(String input)
	{
		if (ObjectChecker.isEmptyOrNull(input))
			return input;
		return prefix + encrypt(input);
	}

	public static String encrypt(String input)
	{
		return encrypt(input, key);
	}

	public static String encrypt(String input, String key)
	{
		return encrypt(input, key.getBytes(StandardCharsets.UTF_8));
	}
	public static String encrypt(String input, byte[] key)
	{
		if (ObjectChecker.isEmptyOrNull(input))
			return input;
		byte[] encrypted = doCrypt(Cipher.ENCRYPT_MODE, input.getBytes(StandardCharsets.UTF_8), key);
		return Base64.toBase64(encrypted);
	}

	public static String safeEncrypt(String input)
	{
		if (input.contains(prefix))
			return input;
		return prefix + encrypt(input);
	}

	public static String decryptIfInputStartsWithPrefix(String input)
	{
		if (ObjectChecker.isEmptyOrNull(input) || !input.startsWith(prefix))
			return input;
		return decryptConsiderPrefix(input);
	}

	public static String decryptConsiderPrefix(String input)
	{
		String encryptedInput = input.substring(prefix.length());
		return decrypt(encryptedInput);
	}

	public static String decrypt(String input)
	{
		return decrypt(input, key);
	}

	public static String decrypt(String input, String key)
	{
		try
		{
			return decrypt(input, key.getBytes("utf-8"));
		}
		catch (UnsupportedEncodingException e)
		{
			throw new RuntimeException(e);
		}
	}
	public static String decrypt(String input, byte[] key)
	{
		if (ObjectChecker.isEmptyOrNull(input))
			return input;
		byte[] decryptedBytes = doCrypt(Cipher.DECRYPT_MODE, Base64.fromBase64(input), key);
		try
		{
			return new String(decryptedBytes, "utf-8");
		}
		catch (UnsupportedEncodingException e)
		{
			throw new RuntimeException(e);
		}
	}

	private static byte[] doCrypt(int cipherMode, byte[] input, byte[] key)
	{
		byte[] outputBytes = null;
		try
		{
			Key secretKey = new SecretKeySpec(key, ALGORITHM);
			Cipher cipher = Cipher.getInstance(TRANSFORMATION);
			cipher.init(cipherMode, secretKey);
			outputBytes = cipher.doFinal(input);

		}
		catch (NoSuchPaddingException | NoSuchAlgorithmException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e)
		{
			e.printStackTrace();
//			NaMaLogger.error(e);
		}
		return outputBytes;
	}

	public static void main(String[] args)
	{
		String s = safeEncrypt("123");
		System.out.println(s);
		System.out.println(decryptConsiderPrefix("$EN$:-8BEB"));
	}

	public static String encrypt1(String input)
	{
		return encrypt(input, "NaIjakaj455236@@");
	}

	public static String decrypt1(String input)
	{
		return decrypt(input, "NaIjakaj455236@@");
	}

	public static String encrypt2(String input)
	{
		return encrypt(input, "osiuiof99@23KLJhdfsadf");
	}

	public static String decrypt2(String input)
	{
		return decrypt(input, "osiuiof99@23KLJhdfsadf");
	}

	public static String encryptX(String input)
	{
		return encrypt(input, "XXsdfkjhILUy2g3556631");
	}

	public static String decryptX(String input)
	{
		return decrypt(input, "XXsdfkjhILUy2g3556631");
	}
}
