package com.namasoft.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

import org.apache.commons.io.FileUtils;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;

public class GUIAppCopier
{
	public static void main(String... args) throws FileNotFoundException, IOException
	{
		File propsFile = getPropetiesFile();
		Properties properties = loadProperties(propsFile);
		String source = args.length > 0 ? args[0] : tryFindingLastCodeServerRun();
		if (source == null)
			source = properties.getProperty("source");
		String destinationn = args.length > 1 ? args[1] : properties.getProperty("destination");
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		System.out.println("Source Folder: default [" + ObjectChecker.toStringOrEmpty(source) + "]");
		if (ObjectChecker.isEmptyOrNull(source))
		{
			String tmp = in.readLine();
			source = ObjectChecker.getFirstNotEmptyObj(tmp, source);
		}
		if (ObjectChecker.isEmptyOrNull(destinationn))
		{
			System.out.println("Destination Folder: default [" + ObjectChecker.toStringOrEmpty(destinationn) + "]");
			String tmp = in.readLine();
			destinationn = ObjectChecker.getFirstNotEmptyObj(tmp, destinationn);
		}
		properties.setProperty("source", source);
		properties.setProperty("destination", destinationn);
		if (args.length < 3)
			saveProperties(propsFile, properties);
		System.out.println("Copying");
		long startTime = System.currentTimeMillis();
		FileUtils.copyDirectory(new File(source), new File(destinationn));
		long time = System.currentTimeMillis() - startTime;
		System.out.println("Done in " + time + " ms");
	}

	public static void saveProperties(File propsFile, Properties properties) throws FileNotFoundException, IOException
	{
		FileOutputStream out = new FileOutputStream(propsFile);
		properties.store(out, "");
		out.close();
	}

	public static Properties loadProperties(File propsFile) throws FileNotFoundException, IOException
	{
		Properties properties = new Properties();
		if (propsFile.exists())
		{
			FileInputStream propsStream = new FileInputStream(propsFile);
			properties.load(propsStream);
			propsStream.close();
		}
		return properties;
	}

	public static File getPropetiesFile()
	{
		String propertiesFileName = ProjectPathUtil.ROOT.replace('\\', '_').replace(':', '_').replace('/', '_');
		File propsFile = new File(new File(WidgetStatePersister.getUserFolder()), propertiesFileName);
		return propsFile;
	}

	private static String tryFindingLastCodeServerRun()
	{
		String tmp = System.getProperty("java.io.tmpdir");
		File tmpFolder = new File(tmp);
		final String prefix = "gwt-codeserver";
		File newestCodeserver = getNewstFile(tmpFolder, prefix);
		if (newestCodeserver == null)
			return null;
		File newsestCompile = getNewstFile(new File(newestCodeserver, "com.namasoft.erp.gui.erpdev"), "compile");
		if (newsestCompile == null)
			return null;
		return new File(newsestCompile, "war").getAbsolutePath();
	}

	private static File getNewstFile(File folder, final String prefix)
	{
		List<File> subfiles = new ArrayList<>(Arrays.asList(folder.listFiles(new FilenameFilter()
		{
			@Override
			public boolean accept(File dir, String name)
			{
				return name.startsWith(prefix);
			}
		})));
		if (subfiles.size() == 0)
			return null;
		Collections.sort(subfiles, new Comparator<File>()
		{
			@Override
			public int compare(File o1, File o2)
			{
				try
				{
					return creationTiime(o1).compareTo(creationTiime(o2));
				}
				catch (IOException e)
				{
					e.printStackTrace();
					return 0;
				}
			}

			private FileTime creationTiime(File o) throws IOException
			{
				Path p = Paths.get(o.getAbsolutePath());
				BasicFileAttributes view = Files.getFileAttributeView(p, BasicFileAttributeView.class).readAttributes();
				FileTime creationTime = view.creationTime();
				return creationTime;
			}
		});
		File newestFile = CollectionsUtility.getLast(subfiles);
		return newestFile;
	}
}
