package com.namasoft.common.utils;

import java.math.BigDecimal;

public interface ItemPriceCalculator
{
	ItemPriceCalculator item(Object itemIdOrCode);

	ItemPriceCalculator customer(Object customerIdOrCode);

	ItemPriceCalculator supplier(Object supplierIdOrCode);

	ItemPriceCalculator uom(Object uomIdOrCode);

	ItemPriceCalculator invoiceClassification(Object classificationIdOrCode);

	default ItemPriceCalculator ic(Object classificationIdOrCode)
	{
		return invoiceClassification(classificationIdOrCode);
	}

	ItemPriceCalculator legalEntity(Object legalEntityIdOrCode);

	default ItemPriceCalculator le(Object legalEntityIdOrCode)
	{
		return legalEntity(legalEntityIdOrCode);
	}

	ItemPriceCalculator sector(Object sectorIdOrCode);

	default ItemPriceCalculator sc(Object sectorIdOrCode)
	{
		return sector(sectorIdOrCode);
	}

	ItemPriceCalculator branch(Object branchIdOrCode);

	default ItemPriceCalculator br(Object branchIdOrCode)
	{
		return branch(branchIdOrCode);
	}

	ItemPriceCalculator department(Object departmentIdOrCode);

	default ItemPriceCalculator dep(Object departmentIdOrCode)
	{
		return department(departmentIdOrCode);
	}

	ItemPriceCalculator analysisSet(Object analysisSetIdOrCode);

	default ItemPriceCalculator anset(Object analysisSetIdOrCode)
	{
		return analysisSet(analysisSetIdOrCode);
	}

	ItemPriceCalculator priceClassifier1(Object priceClassifier1IdOrCode);

	default ItemPriceCalculator pc1(Object priceClassifier1IdOrCode)
	{
		return priceClassifier1(priceClassifier1IdOrCode);
	}

	ItemPriceCalculator priceClassifier2(Object priceClassifier2IdOrCode);

	default ItemPriceCalculator pc2(Object priceClassifier2IdOrCode)
	{
		return priceClassifier2(priceClassifier2IdOrCode);
	}

	ItemPriceCalculator priceClassifier3(Object priceClassifier3IdOrCode);

	default ItemPriceCalculator pc3(Object priceClassifier3IdOrCode)
	{
		return priceClassifier3(priceClassifier3IdOrCode);
	}

	ItemPriceCalculator priceClassifier4(Object priceClassifier4IdOrCode);

	default ItemPriceCalculator pc4(Object priceClassifier4IdOrCode)
	{
		return priceClassifier4(priceClassifier4IdOrCode);
	}

	ItemPriceCalculator priceClassifier5(Object priceClassifier5IdOrCode);

	default ItemPriceCalculator pc5(Object priceClassifier5IdOrCode)
	{
		return priceClassifier5(priceClassifier5IdOrCode);
	}

	ItemPriceCalculator revision(Object revision);

	ItemPriceCalculator color(Object colorCode);

	ItemPriceCalculator size(Object size);

	ItemPriceCalculator qty(Object qty);

	ItemPriceCalculator date(Object date);

	ItemPriceCalculator unitPriceOnly();

	BigDecimal unitPrice();

	Object price();

}
