package com.namasoft.common.utils;

import jakarta.xml.bind.annotation.*;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class MobileQrResponse
{
	private String responseText;
	private Boolean success = true;

	public static MobileQrResponse success(String responseText)
	{
		MobileQrResponse response = new MobileQrResponse();
		response.setResponseText(responseText);
		response.setSuccess(true);
		return response;
	}

	public static MobileQrResponse failure(String responseText)
	{
		MobileQrResponse response = new MobileQrResponse();
		response.setResponseText(responseText);
		response.setSuccess(false);
		return response;
	}

	public String getResponseText()
	{
		return responseText;
	}

	public void setResponseText(String responseText)
	{
		this.responseText = responseText;
	}

	public Boolean getSuccess()
	{
		return success;
	}

	public void setSuccess(Boolean success)
	{
		this.success = success;
	}
}
