package com.namasoft.common.utils;

import com.namasoft.common.utilities.ObjectChecker;

import java.math.BigDecimal;
import java.util.*;

public interface NaMaLayersConnectorHelper
{
	Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode);

	Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode, Object date);

	Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode, Object date,
			Object legalEntityIdOrCode);

	Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode, Object date,
			Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode, Object analysisSetIdOrCode, Object departmentIdOrCode,
			Object revisionIdCode, Object colorCode, Object sizeCode);

	Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode, Object date,
			Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode, Object analysisSetIdOrCode, Object departmentIdOrCode,
			Object revisionIdCode, Object colorCode, Object sizeCode, Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode,
			Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode, Object priceClassifier5IdOrCode);

	Object getPurchasePricesForSupplier(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
			Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode, Object analysisSetIdOrCode,
			Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode, Object priceClassifier1IdOrCode,
			Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode, Object priceClassifier5IdOrCode);

	Object getPricesForCustomer(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
			Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
			Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode);

	Object getPricesForCustomer(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
			Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
			Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode,
			Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode,
			Object priceClassifier5IdOrCode);

	Object getPurchasePricesForSupplier(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
			Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
			Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode,
			Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode,
			Object priceClassifier5IdOrCode);

	boolean supportsItemPrice();

	boolean supportsPurchaseValue();

	BigDecimal getItemPriceById(Object itemId);

	BigDecimal getItemPriceByCode(Object itemCode);

	BigDecimal getNetPurchaseValue(Object itemCode);

	BigDecimal getItemPriceForCustomer(Object item, Object customer);

	BigDecimal getItemDiscountForCustomer(Object item, Object customer, Object discountIndex);

	Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty);

	Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode);

	default ItemPriceCalculator createPriceCalculator()
	{
		return null;
	}

	public static class Default implements NaMaLayersConnectorHelper
	{

		@Override
		public boolean supportsItemPrice()
		{
			return false;
		}

		@Override
		public boolean supportsPurchaseValue()
		{
			return false;
		}

		@Override
		public BigDecimal getItemPriceById(Object itemId)
		{
			return null;
		}

		@Override
		public BigDecimal getItemPriceByCode(Object itemCode)
		{
			return null;
		}

		@Override
		public BigDecimal getNetPurchaseValue(Object itemCode)
		{
			return null;
		}

		@Override
		public BigDecimal getItemPriceForCustomer(Object item, Object customer)
		{
			return null;
		}

		@Override
		public BigDecimal getItemDiscountForCustomer(Object item, Object customer, Object discountIndex)
		{
			return null;
		}

		@Override
		public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty)
		{
			return null;
		}

		@Override
		public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode)
		{
			return null;
		}

		@Override
		public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode)
		{
			return null;
		}

		@Override
		public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
				Object date)
		{
			return null;
		}

		@Override
		public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
				Object date, Object legalEntityIdOrCode)
		{
			return null;
		}

		@Override
		public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
				Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode, Object analysisSetIdOrCode,
				Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode)
		{
			return null;
		}

		@Override
		public Object getPricesForCustomer(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty, Object classificationIdOrCode,
				Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode, Object analysisSetIdOrCode,
				Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode, Object priceClassifier1IdOrCode,
				Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode, Object priceClassifier5IdOrCode)
		{
			return null;
		}

		@Override
		public Object getPurchasePricesForSupplier(Object itemIdOrCode, Object customerIdOrCode, Object uom, Object qty,
				Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
				Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode,
				Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode,
				Object priceClassifier5IdOrCode)
		{
			return null;
		}

		@Override
		public Object getPricesForCustomer(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
				Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
				Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode)
		{
			return null;
		}

		@Override
		public Object getPricesForCustomer(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
				Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
				Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode,
				Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode,
				Object priceClassifier5IdOrCode)
		{
			return null;
		}

		@Override
		public Object getPurchasePricesForSupplier(Map parametersMap, Object itemIdOrCode, Object customerIdOrCode, Object oUom, Object oQty,
				Object classificationIdOrCode, Object date, Object legalEntityIdOrCode, Object sectorIdOrCode, Object branchIdOrCode,
				Object analysisSetIdOrCode, Object departmentIdOrCode, Object revisionIdCode, Object colorCode, Object sizeCode,
				Object priceClassifier1IdOrCode, Object priceClassifier2IdOrCode, Object priceClassifier3IdOrCode, Object priceClassifier4IdOrCode,
				Object priceClassifier5IdOrCode)
		{
			return null;
		}
	}

	default List<String> unzipSerials(Object serials)
	{
		if (ObjectChecker.isEmptyOrNull(serials))
			return Collections.emptyList();
		return Arrays.asList(ObjectChecker.toStringOrEmpty(serials));
	}
}
