package com.namasoft.common.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

import com.namasoft.common.utilities.NaMaLogger;

public class NamaScriptUtil
{
	private static ScriptEngine scriptEngine;

	public static void main(String[] args)
	{
		HashMap<String, Object> parameters = new HashMap<String, Object>();
		parameters.put("w", BigDecimal.ONE);
		parameters.put("l", BigDecimal.TEN);
		parameters.put("h", 4);
		System.out.println(runScript("l*(l+w)*2", parameters, true));
	}

	public static Object runScript(String script, Map<String, Object> parameters, boolean throwExceptions)
	{
		if (scriptEngine == null)
		{
			ScriptEngineManager mgr = new ScriptEngineManager();
			scriptEngine = mgr.getEngineByName("JavaScript");
		}
		try
		{
			return scriptEngine.eval(script, new SimpleBindings(parameters));
		}
		catch (ScriptException e)
		{
			NaMaLogger.error(e);
			if (throwExceptions)
				throw new RuntimeException(e);
			return null;
		}
	}
}
