package com.namasoft.common.utils;

import com.namasoft.common.utilities.ObjectChecker;

import java.io.File;
import java.util.Arrays;

public class ProjectPathUtil
{
	public final static String ROOT = getNaMaERPRoot().getAbsolutePath();
	public static final String NAMA_COMMON_ROOT = ROOT + "/infra/nama-common/";
	public static final String POS_GUI_ROOT = ROOT + "/modules/namapos/namaposgui/";
	public static final String NAMA_GUI_ROOT = ROOT + "/infra/gui-base/";
	public static final String DM_XML_DOMAIN_BASE_RESOURCES = ROOT + "/infra/domain-base/src/main/resources/dm.zip";
	public static final String NAMA_GUI2_ROOT = ROOT + "/infra/gui2/";
	public static final String CLOUD_MAN_ROOT = ROOT + "/cloudman/";
	public static final String NAMA_GUI_CORE_ROOT = ROOT + "/infra/gui-core/";
	public static final String NAMA_MAGENTO_CLIENT = ROOT + "/modules/magento/nama-magento-client/src/main/java";
	public static final String BIG_COMMERCE_CLIENT = ROOT + "/modules/magento/nama-big-commerce-client/src/main/java";

	private static File getNaMaERPRoot()
	{
		String currentPath = getWorkingDirectory();
		if(ObjectChecker.isNotEmptyOrNull(System.getProperty("NamaProjectPath")))
			currentPath = System.getProperty("NamaProjectPath");
		File file = new File(currentPath);
		while (file != null && !file.getName().equalsIgnoreCase("modules") && !file.getName().equalsIgnoreCase("infra") && !file.getName()
				.equalsIgnoreCase("nama-erp")  && !file.getName()
				.equalsIgnoreCase("namaerp6060")&& !file.getName().equalsIgnoreCase("namaerp-git") && !file.getName().equalsIgnoreCase("code")
				&& !file.getName().equalsIgnoreCase("customers") && !file.getName().equalsIgnoreCase("low"))
		{
			if (Arrays.stream(file.listFiles()).anyMatch(f -> f.getName().equals("modules")))
				break;
			file = file.getParentFile();
		}
		if (file.getName().equalsIgnoreCase("modules") || file.getName().equalsIgnoreCase("infra")|| file.getName().equalsIgnoreCase("customers"))
			file = file.getParentFile();
		if (file.getName().equalsIgnoreCase("low"))
			file = new File(file.getParentFile(), "code");
		return file;
	}

	public static void main(String[] args)
	{
		System.out.println(ROOT);
	}
	public static String getWorkingDirectory()
	{
		return System.getProperty("user.dir");
	}
}
