package com.namasoft.common.utils;

import jakarta.xml.bind.MarshalException;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.http.HTTPException;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import java.rmi.UnexpectedException;
import java.util.UUID;

public class ServerCommonUtils
{
	public static UUID byteArrayToUUID(byte[] bytes)
	{
		ByteBuffer buffer = ByteBuffer.wrap(bytes);
		long msb = buffer.getLong();
		long lsb = buffer.getLong();
		return new UUID(msb, lsb);
	}

	public static boolean isWebServiceConnectivityException(Throwable e)
	{
		boolean isConnectError = e instanceof UnexpectedException && e.getCause() instanceof WebServiceException && e.getCause().getCause()
				.getCause() instanceof ConnectException;
		boolean isHttpError = e instanceof UnexpectedException && e.getCause() instanceof WebServiceException && e.getCause().getCause()
				.getCause() instanceof HTTPException;
		boolean linkedWithConnectException =
				(e.getCause() instanceof MarshalException) && ((MarshalException) e.getCause())
						.getLinkedException() instanceof ConnectException;
		return isConnectError || isHttpError || linkedWithConnectException;
	}
}
