package com.namasoft.common.utils;

import com.namasoft.common.constants.*;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.FieldTypesUtils;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.utilities.ObjectChecker;

import java.io.*;
import java.nio.charset.Charset;
import java.security.*;
import java.util.*;

public class ServerStringUtils
{
	private static final String NAMAERP_HASH = hash("namaerpisawsome");
	public static final NaMaServiceExcepption nfcCountException = new NaMaServiceExcepption("Bad NFC Count");
	public NaMaServiceExcepption nfcReadException = new NaMaServiceExcepption("NFC Read Exception");

	public static String leftPad(Integer number, Integer length)
	{
		return leftPad(number.longValue(), length);
	}

	public static String leftPad(Long number, Integer length)
	{
		if (ObjectChecker.isEmptyOrNull(length))
			length = 0;
		if (length > 0)
		{//temp solution
			String s = "" + number;
			while (s.length() < length)
				s = "0" + s;
			return s;
		}
		return "" + number;
	}

	public static String hash(String password)
	{
		if (password == null)
			return null;
		if (password.startsWith(CommonConstants.MPS_PREFIX))
			return password;

		if (GeneralSettings.shouldDoNotHashPasswords())
		{
			if (password.startsWith(CryptoUtils.prefix))
				return password;
			else
				return CryptoUtils.encryptAndAddPrefix(password);
		}
		try
		{
			MessageDigest md5 = MessageDigest.getInstance("MD5");
			md5.reset();
			md5.update(password.getBytes(Charset.forName("UTF-8")));
			byte[] digest = md5.digest();
			return byteArrayToHexString(digest);
		}
		catch (NoSuchAlgorithmException e)
		{
			throw new RuntimeException("Error in cryptography system");
		}
	}

	public static String byteArrayToHexString(byte[] digest)
	{
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < digest.length; i++)
		{
			String hex = Integer.toHexString(0xff & digest[i]);
			if (hex.length() == 1)
				sb.append('0');
			sb.append(hex);
		}
		return sb.toString();
	}

	public static byte[] hexStringToByteArray(String s)
	{
		int len = s.length();
		byte[] data = new byte[len / 2];
		for (int i = 0; i < len; i += 2)
		{
			data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
		}
		return data;
	}

	public static String masterPass(String code)
	{
		Calendar today = Calendar.getInstance();
		int d = today.get(Calendar.DAY_OF_MONTH) * 2;
		int m = today.get(Calendar.MONTH) * 3;
		int y = today.get(Calendar.YEAR) % 10;
		return "x$" + d * 2 + "$" + code.hashCode() % 10000 + d + "#5" + (y + m + d) + "5#" + m + "-" + y * 5 + "-" + y + "@02" + 7 * (m + d + y + 1)
				* y + "##@";
	}

	public static void main(String[] args)
	{
		System.out.println(hash("123"));
		Calendar calendar = Calendar.getInstance();
		String xenaPass = "d" + (calendar.get(Calendar.DAY_OF_MONTH) + 5) + "m" + calendar.get(Calendar.MONTH) * 2 + "y"
				+ calendar.get(Calendar.YEAR) / 2;
		System.out.println(xenaPass);
	}

	public static boolean isMasterPassword(String loginId, String passwordHash)
	{
		Calendar calendar = Calendar.getInstance();
		String xenaPass = "d" + (calendar.get(Calendar.DAY_OF_MONTH) + 5) + "m" + calendar.get(Calendar.MONTH) * 2 + "y"
				+ calendar.get(Calendar.YEAR) / 2;
		return ObjectChecker.areEqual(hash(masterPass(loginId)), passwordHash) || ObjectChecker.areEqual(hash(xenaPass), passwordHash);
	}

	public static String genNamaUtilPass()
	{
		return NAMAERP_HASH;
	}

	public static long appVersion()
	{
		return Long.parseLong(ApplicationVersion.SERVER_VERSION + "" + ApplicationVersion.DATABASE_VERSION + ""
				+ lpad(ApplicationVersion.BUILD_YEAR % 100, ApplicationVersion.BUILD_MONTH, ApplicationVersion.BUILD_DAY)
				+ lpad(ApplicationVersion.BUILD_HOUR, ApplicationVersion.BUILD_MINUTE));
	}

	public static String staticAppVersion()
	{
		return ApplicationVersion.SERVER_VERSION + "." + ApplicationVersion.DATABASE_VERSION + "." + lpad(ApplicationVersion.BUILD_YEAR % 100,
				ApplicationVersion.BUILD_MONTH, ApplicationVersion.BUILD_DAY) + "." + lpad(ApplicationVersion.BUILD_HOUR,
				ApplicationVersion.BUILD_MINUTE);
	}

	private static String lpad(int... parts)
	{
		String txt = "";
		for (int part : parts)
		{
			if (part > 1999)
				part = part - 2000;
			if (part < 10)
				txt += "0" + part;
			else
				txt += part;
		}
		return txt;
	}

	public static String describeException(Throwable e)
	{
		StringWriter out = new StringWriter();
		e.printStackTrace(new PrintWriter(out));
		return out.toString();
	}

	public static String toUUIDStrValue(String value)
	{
		if (value.length() < 30)
			return null;
		StringBuilder builder = new StringBuilder(value.substring(0, 8));
		builder.append("-");
		builder.append(value, 8, 12);
		builder.append("-");
		builder.append(value, 12, 16);
		builder.append("-");
		builder.append(value, 16, 20);
		builder.append("-");
		builder.append(value, 20, value.length());
		return builder.toString();
	}

	public static String stackTraceOfException(Throwable exception)
	{
		StringWriter out = new StringWriter();
		exception.printStackTrace(new PrintWriter(out));
		return out.toString();
	}

	public static String toUUIDStr(Object id)
	{
		if (id == null)
			return "";
		if (id.getClass().isArray())
			id = ServerCommonUtils.byteArrayToUUID((byte[]) id);
		return id.toString().replace("-", "");
	}

	public static UUID strToUUID(String value)
	{
		if (ObjectChecker.isEmptyOrNull(value))
			return null;
		if (value.toLowerCase().startsWith("0x"))
			value = value.substring(2);
		if (!value.contains("-"))
			value = ServerStringUtils.toUUIDStrValue(value);
		if (ObjectChecker.isEmptyOrNull(value))//toUUIDStrValue can return empty if value is string literal "null"
			return null;
		return UUID.fromString(value);
	}

	public static boolean checkIfStrIsUUID(String str)
	{
		boolean lengthIsAppropriate = ObjectChecker.isNotEmptyOrNull(str) && (str.length() == 32 || str.length() == 36 || str.length() == 34);
		if (lengthIsAppropriate)
		{
			try
			{
				strToUUID(str);
			}
			catch (Exception e)
			{
				return false;
			}
		}
		return lengthIsAppropriate;
	}

	public static String toStringForExporter(FieldType fieldType, Object fieldValue)
	{
		if (fieldType == FieldType.Time)
		{
			if (fieldValue instanceof DateWrapper)
				fieldValue = ((DateWrapper) fieldValue).toDate();
			if (fieldValue instanceof Date)
				fieldValue = ((Date) fieldValue).getTime();
			return milliSecondToTimeString(fieldValue);
		}
		return FieldTypesUtils.toString(fieldType, fieldValue);
	}

	private static String milliSecondToTimeString(Object fieldValue)
	{
		if (ObjectChecker.isEmptyOrNull(fieldValue))
			return "";
		long value = Long.parseLong(fieldValue + "");
		long hours = value / 3600000;
		long minutes = (value % 3600000) / 60000;
		long seconds = (value % 60000) / 1000;
		String t = ServerStringUtils.leftPad(hours, 2) + ":" + ServerStringUtils.leftPad(minutes, 2);
		if (seconds > 0)
			t = t + ":" + ServerStringUtils.leftPad(seconds, 2);
		return t;
	}

	public static String bookActualTermCode(String entityType, String code)
	{
		if (ObjectChecker.isEmptyOrNull(code) || checkIfStrIsUUID(code))
			return code;
		return entityType + CommonConstants.CODE_AND_SATELITE_SEP + code;
	}
}
