package com.namasoft.common.utils;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.Set;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;

@SuppressWarnings("rawtypes")
public class WidgetStatePersister
{
	private String applicationName;
	private HashMap<String, Object> widgetsFields = new HashMap<>();

	public WidgetStatePersister(Object owner, String applicationName, boolean autoSave, Object... widgets)
	{
		if (autoSave)
		{
			for (Object widget : widgets)
			{
				if (widget instanceof JComponent)
				{
					((JComponent) widget).addFocusListener(new FocusListener()
					{
						@Override
						public void focusLost(FocusEvent e)
						{
							saveProperties();
						}

						@Override
						public void focusGained(FocusEvent e)
						{
						}
					});
				}
			}
		}
		this.applicationName = applicationName;
		Set<Field> fields = new HashSet<Field>();
		fields.addAll(Arrays.asList(owner.getClass().getDeclaredFields()));
		fields.addAll(Arrays.asList(owner.getClass().getFields()));
		for (Field field : fields)
		{
			field.setAccessible(true);
			Object fieldValue = null;
			try
			{
				fieldValue = field.get(owner);
			}
			catch (Exception e)
			{
			}
			if (fieldValue != null)
			{
				for (Object widget : widgets)
				{
					if (widget == fieldValue)
					{
						widgetsFields.put(field.getName(), widget);
						break;
					}
				}
			}
		}

	}

	private Properties loadPropertiesFromFile()
	{
		Properties properties = new Properties();
		File propertiesFile = getPropertiesFile();
		if (!propertiesFile.exists())
			return properties;
		try (FileInputStream in = new FileInputStream(propertiesFile))
		{
			properties.load(in);
		}
		catch (Exception e)
		{
		}

		return properties;
	}

	public void loadPropertiesToWidgets()
	{
		Properties properties = loadPropertiesFromFile();
		for (Entry<String, Object> widget : widgetsFields.entrySet())
		{
			String property = properties.getProperty(widget.getKey());
			if (property != null)
				setValue(widget.getValue(), property);
		}
	}

	private void setValue(Object widget, String value)
	{
		if (widget instanceof JPasswordField)
			((JPasswordField) widget).setText(value);
		else if (widget instanceof JTextField)
			((JTextField) widget).setText(value);
		else if (widget instanceof JComboBox)
			((JComboBox) widget).setSelectedItem(value);
		else if (widget instanceof JTextArea)
			((JTextArea) widget).setText(value);
		else if (widget instanceof CustomWidgetPersister)
			((CustomWidgetPersister) widget).setState(value);
	}

	private String getValue(Object widget)
	{
		if (widget instanceof JPasswordField)
			return new String(((JPasswordField) widget).getPassword());
		else if (widget instanceof JTextField)
			return ((JTextField) widget).getText();
		else if (widget instanceof JComboBox)
			return ((JComboBox) widget).getSelectedItem() + "";
		else if (widget instanceof JTextArea)
			return ((JTextArea) widget).getText();
		else if (widget instanceof CustomWidgetPersister)
			return ((CustomWidgetPersister) widget).getState();
		return "";
	}

	private File getPropertiesFile()
	{
		File propertiesFile = new File(getHomeFolder() + "/state.ini");
		return propertiesFile;
	}

	public void saveProperties()
	{
		Properties properties = loadPropertiesFromFile();
		for (Entry<String, Object> widget : widgetsFields.entrySet())
		{
			properties.setProperty(widget.getKey(), getValue(widget.getValue()));
		}
		try
		{
			properties.store(new FileOutputStream(getPropertiesFile()), "");
		}
		catch (Exception e)
		{
		}
	}

	private String getHomeFolder()
	{
		File file = new File(getUserFolder() + "/" + applicationName);
		file.mkdirs();
		return file.getAbsolutePath();
	}

	public static String getUserFolder()
	{
		return new File(System.getProperty("user.home")).getAbsolutePath();
	}
}
