package com.namasoft.common.utils.dashboard;

import java.sql.*;
import java.util.*;

public class AGGridUtils
{
	public enum AGGridCellDataType
	{
		TEXT("text"), NUMBER("number"), BOOLEAN("boolean"), DATE("date"), DATE_STRING("dateString"), DATE_TIME("dateTime"), DATE_TIME_STRING(
			"dateTimeString"), OBJECT("object");

		private final String value;

		AGGridCellDataType(String value)
		{
			this.value = value;
		}

		public String getValue()
		{
			return value;
		}

		@Override
		public String toString()
		{
			return value;
		}
	}

	private static final Map<Integer, AGGridCellDataType> SQL_TYPE_CACHE = new HashMap<>();

	static
	{
		SQL_TYPE_CACHE.put(Types.VARCHAR, AGGridCellDataType.TEXT);
		SQL_TYPE_CACHE.put(Types.NVARCHAR, AGGridCellDataType.TEXT);
		SQL_TYPE_CACHE.put(Types.CHAR, AGGridCellDataType.TEXT);
		SQL_TYPE_CACHE.put(Types.NCHAR, AGGridCellDataType.TEXT);
		SQL_TYPE_CACHE.put(Types.LONGVARCHAR, AGGridCellDataType.TEXT);
		SQL_TYPE_CACHE.put(Types.LONGNVARCHAR, AGGridCellDataType.TEXT);
		SQL_TYPE_CACHE.put(Types.CLOB, AGGridCellDataType.TEXT);
		SQL_TYPE_CACHE.put(Types.NCLOB, AGGridCellDataType.TEXT);

		SQL_TYPE_CACHE.put(Types.INTEGER, AGGridCellDataType.NUMBER);
		SQL_TYPE_CACHE.put(Types.BIGINT, AGGridCellDataType.NUMBER);
		SQL_TYPE_CACHE.put(Types.SMALLINT, AGGridCellDataType.NUMBER);
		SQL_TYPE_CACHE.put(Types.TINYINT, AGGridCellDataType.NUMBER);
		SQL_TYPE_CACHE.put(Types.DECIMAL, AGGridCellDataType.NUMBER);
		SQL_TYPE_CACHE.put(Types.NUMERIC, AGGridCellDataType.NUMBER);
		SQL_TYPE_CACHE.put(Types.FLOAT, AGGridCellDataType.NUMBER);
		SQL_TYPE_CACHE.put(Types.DOUBLE, AGGridCellDataType.NUMBER);
		SQL_TYPE_CACHE.put(Types.REAL, AGGridCellDataType.NUMBER);

		SQL_TYPE_CACHE.put(Types.BIT, AGGridCellDataType.BOOLEAN);
		SQL_TYPE_CACHE.put(Types.BOOLEAN, AGGridCellDataType.BOOLEAN);

		SQL_TYPE_CACHE.put(Types.DATE, AGGridCellDataType.DATE);
		SQL_TYPE_CACHE.put(Types.TIMESTAMP, AGGridCellDataType.DATE_TIME);
		SQL_TYPE_CACHE.put(Types.TIMESTAMP_WITH_TIMEZONE, AGGridCellDataType.DATE_TIME);
		SQL_TYPE_CACHE.put(Types.TIME, AGGridCellDataType.DATE_TIME);
		SQL_TYPE_CACHE.put(Types.TIME_WITH_TIMEZONE, AGGridCellDataType.DATE_TIME);

		SQL_TYPE_CACHE.put(Types.BLOB, AGGridCellDataType.OBJECT);
		SQL_TYPE_CACHE.put(Types.BINARY, AGGridCellDataType.OBJECT);
		SQL_TYPE_CACHE.put(Types.VARBINARY, AGGridCellDataType.OBJECT);
		SQL_TYPE_CACHE.put(Types.LONGVARBINARY, AGGridCellDataType.OBJECT);
	}

	public static AGGridCellDataType mapSqlTypeToGridCellDataType(int sqlType)
	{
		AGGridCellDataType cachedType = SQL_TYPE_CACHE.get(sqlType);
		if (cachedType != null)
			return cachedType;
		return AGGridCellDataType.TEXT;
	}

	public static String mapSqlTypeToGridCellDataTypeString(int type)
	{
		return mapSqlTypeToGridCellDataType(type).getValue();
	}

	public static void addColumnNamesWithTypesToMap(ResultSetMetaData metaData, Map<String, String> columnNamesWithTypes)
	{
		if (columnNamesWithTypes == null || metaData == null)
			return;
		try
		{
			int columnCount = metaData.getColumnCount();
			for (int i = 1; i <= columnCount; i++)
			{
				String columnName = metaData.getColumnLabel(i);
				if (!columnNamesWithTypes.containsKey(columnName))
					columnNamesWithTypes.put(columnName, mapSqlTypeToGridCellDataTypeString(metaData.getColumnType(i)));
			}
		}
		catch (SQLException ignored)
		{
		}
	}
}