package com.namasoft.common.utils.dm.pojo;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.util.*;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class DMDetail extends NaMaDTO implements DMContainer, Comparable<DMDetail>
{
	private String fullName;
	private String joinColumn;
	private String tableName;
	private String arabicName;
	private String englishName;
	private String className;
	private List<DMProperty> properties = new ArrayList<>();
	private List<DMDetail> details = new ArrayList<>();

	public String getFullName()
	{
		return fullName;
	}

	public void setFullName(String fullName)
	{
		this.fullName = fullName;
	}

	public String getJoinColumn()
	{
		return joinColumn;
	}

	public void setJoinColumn(String joinColumn)
	{
		this.joinColumn = joinColumn;
	}

	public String getTableName()
	{
		return tableName;
	}

	public void setTableName(String tableName)
	{
		this.tableName = tableName;
	}

	public String getArabicName()
	{
		return arabicName;
	}

	public void setArabicName(String arabicName)
	{
		this.arabicName = arabicName;
	}

	public String getEnglishName()
	{
		return englishName;
	}

	public void setEnglishName(String englishName)
	{
		this.englishName = englishName;
	}

	public List<DMProperty> getProperties()
	{
		return properties;
	}

	public void setProperties(List<DMProperty> properties)
	{
		this.properties = properties;
	}

	public List<DMDetail> getDetails()
	{
		return details;
	}

	public void setDetails(List<DMDetail> details)
	{
		this.details = details;
	}

	public String getClassName()
	{
		return className;
	}

	@Override
	public DMDetail prefixWith(String prefixWith)
	{
		if (ObjectChecker.isEmptyOrNull(prefixWith))
			return this;
		return cloneToADifferentFullNameWithoutProps(prefixWith + "." + getFullName());
	}

	@Override
	public String fetchFullName()
	{
		return getFullName();
	}

	public DMDetail cloneToADifferentFullNameWithoutProps(String newFullName)
	{
		DMDetail d = new DMDetail();
		d.fullName = newFullName;
		d.joinColumn = joinColumn;
		d.tableName = tableName;
		d.arabicName = arabicName;
		d.englishName = englishName;
		d.className = className;
		return d;
	}

	public void setClassName(String className)
	{
		this.className = className;
	}

	public void finishDefinition()
	{
		Collections.sort(getProperties());
	}

	@Override
	public int compareTo(DMDetail o)
	{
		if (o == null)
			return 1;
		return getFullName().compareTo(o.getFullName());
	}

}
