package com.namasoft.common.utils.dm.pojo;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.util.*;
import java.util.stream.Collectors;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class DMPersister extends NaMaDTO
{
	private List<DMEntity> entities = new ArrayList<DMEntity>();
	private List<DMEntity> extraEntities;

	public void addExtraEntity(DMEntity entity)
	{
		if (extraEntities == null)
			extraEntities = new ArrayList<>();
		extraEntities.add(entity);
	}

	public List<DMEntity> getExtraEntities()
	{
		return extraEntities;
	}

	public List<DMEntity> getEntities()
	{
		return entities;
	}

	public void setEntities(List<DMEntity> entities)
	{
		this.entities = entities;
	}

	public DMEntity findEntity(String forEntityType)
	{
		if (ObjectChecker.isNotEmptyOrNull(extraEntities))
		{
			DMEntity fromExtra = extraEntities.stream().filter(ObjectChecker.equalsPredicate(forEntityType, DMEntity::getEntityName)).findFirst()
					.orElse(null);
			if (fromExtra != null)
				return fromExtra;
		}
		return getEntities().stream().filter(ObjectChecker.equalsPredicate(forEntityType, DMEntity::getEntityName)).findFirst().orElse(null);
	}

	public DMPropWithParent findField(String entityType, String fieldName, String prefixWith)
	{
		return findField(entityType, fieldName, prefixWith, false);
	}

	public DMPropWithParent findField(String entityType, String fieldName, String prefixWith, boolean translateIfNeeded)
	{
		return findField(entityType, fieldName, prefixWith, translateIfNeeded, new ArrayList<>());
	}

	public DMPropWithParent findField(String entityType, String fieldName, String prefixWith, boolean translateIfNeeded, List<DMProperty> parentsPath)
	{
		DMEntity entity = findEntity(entityType);
		if (entity == null)
			return null;
		entity = entity.prefixWith(prefixWith);
		if (translateIfNeeded)
		{
			if (entity.getProperties().get(0).getArabicName() == null)
			{
				entity.translate();
			}
		}
		DMPropWithParent field = entity.findField(fieldName, this, prefixWith, translateIfNeeded, parentsPath);
		if (field != null)
			field.setParentsPath(parentsPath.stream().map(DMProperty::getFullName).collect(Collectors.toList()));
		return field;
	}

	public DMEntity findEntityByTableName(String table)
	{
		return getEntities().stream().filter(ObjectChecker.equalsPredicate(table, DMEntity::getTableName)).findFirst().orElse(null);
	}

	public void cloneAndReplaceEntity(DMEntity entity)
	{
		DMEntity cloned = entity.cloneData();
		if (extraEntities != null)
		{
			extraEntities.removeIf(ObjectChecker.equalsPredicate(entity.getEntityName(), DMEntity::getEntityName));
		}
		addExtraEntity(cloned);
	}
}
