package com.namasoft.common.utils.dm.pojo;

import com.namasoft.common.utilities.*;

import java.util.*;

public class DMPropWithParent
{
	private List<String> parentsPath;
	private List<DMJoin> joins = new ArrayList<>();
	private DMProperty parentProperty;
	private DMProperty property;
	private DMContainer parent;
	private DMEntity root;
	public DMPropWithParent addSingleJoinIfNeeded()
	{
		return addSingleJoinIfNeeded(parent.getTableName(), StringUtils.toCamelCaseAndReplaceDotsWith_(parent.fetchFullName()),
				parent.fetchFullName());
	}

	public DMPropWithParent addSingleJoinIfNeeded(String mainTableName, String mainTableAlias, String mainTablePropertyName)
	{
		if (ObjectChecker.isNotEmptyOrNull(property.getReferenceTo()))
		{
			DMJoin join = createToOneJoin(mainTableName, mainTableAlias, mainTablePropertyName, property);
			joins.add(join);
		}
		return this;
	}

	public static DMJoin createToOneJoin(String mainTableName, String mainTableAlias, String mainTablePropertyName, DMProperty property)
	{
		DMJoin join = new DMJoin();
		join.mainTableName = mainTableName;
		join.mainTableAlias = mainTableAlias;
		if (ObjectChecker.isNotEmptyOrNull(property.getColumnName()))
			join.mainTableColumn = CollectionsUtility.getLast(StringUtils.csvLineToList(property.fetchColumnName())).trim();
		join.joinedTableName = property.getReferenceTo();
		join.joinedTableAlias = property.fullNameToCamelCase();
		join.joinedTablePropertyName = property.getFullName();
		join.joinedTableColumn = ObjectChecker.getFirstNotEmptyObj(property.getJoinReferenceToBy(), "id");
		join.mainTablePropertyName = mainTablePropertyName;
		return join;
	}

	public DMPropWithParent addJoinForDetail(DMEntity mainEntity)
	{
		return addJoinForDetail(mainEntity.getTableName(), StringUtils.toCamelCaseAndReplaceDotsWith_(mainEntity.fetchFullName()),
				mainEntity.fetchFullName());
	}

	public DMPropWithParent addJoinForDetail(String mainTableName, String mainTableAlias, String mainTablePropertyName)
	{
		DMJoin detailJoin = createToManyJoin(mainTableName, mainTableAlias, mainTablePropertyName, (DMDetail) parent);
		joins.add(detailJoin);
		addSingleJoinIfNeeded(detailJoin.joinedTableName, detailJoin.joinedTableAlias, detailJoin.joinedTablePropertyName);
		return this;
	}

	public static DMJoin createToManyJoin(String mainTableName, String mainTableAlias, String mainTablePropertyName, DMDetail parent)
	{
		DMJoin detailJoin = new DMJoin();
		detailJoin.mainTableName = mainTableName;
		detailJoin.mainTableAlias = mainTableAlias;
		detailJoin.mainTableColumn = "id";
		detailJoin.joinedTableName = parent.getTableName();
		detailJoin.joinedTableAlias = StringUtils.toCamelCaseAndReplaceDotsWith_(parent.getFullName());
		detailJoin.joinedTableColumn = parent.getJoinColumn();
		detailJoin.joinedTablePropertyName = parent.getFullName();
		detailJoin.mainTablePropertyName = mainTablePropertyName;
		return detailJoin;
	}

	public void assignParentPropertyIfEmpty(DMProperty parent)
	{
		if (this.parentProperty == null)
			this.parentProperty = parent;
	}

	public void setParentsPath(List<String> parentsPath)
	{
		this.parentsPath = parentsPath;
	}

	public List<String> getParentsPath()
	{
		return parentsPath;
	}

	public ParentsInfo calcFieldParentsInfo(DMEntity root)
	{
		boolean isDirectChild = ObjectChecker.areEqual(getParent().fetchFullName(), "mainEntity") || getParentProperty() == null;
		String parentFullName = isDirectChild ? "" : getParentProperty().getFullName();
		String fieldName = isDirectChild ? getProperty().getFullName() : getProperty().getFullName().substring(parentFullName.length() + 1);
		String parentEntityType ;
		if (isDirectChild)
			parentEntityType = root.getEntityName();
		else
			parentEntityType = getParentProperty().getReferenceTo();
		return new ParentsInfo(parentEntityType,parentFullName,fieldName);
	}

	public static class ParentsInfo
	{
		private String parentEntity;
		private String parentFullName;
		private String fieldName;

		public ParentsInfo(String parentEntity, String parentFullName, String fieldName)
		{
			this.parentEntity = parentEntity;
			this.parentFullName = parentFullName;
			this.fieldName = fieldName;
		}

		public String getParentEntity()
		{
			return parentEntity;
		}

		public void setParentEntity(String parentEntity)
		{
			this.parentEntity = parentEntity;
		}

		public String getParentFullName()
		{
			return parentFullName;
		}

		public void setParentFullName(String parentFullName)
		{
			this.parentFullName = parentFullName;
		}

		public String getFieldName()
		{
			return fieldName;
		}

		public void setFieldName(String fieldName)
		{
			this.fieldName = fieldName;
		}
	}

	public static class DMJoin
	{
		private String mainTablePropertyName;
		private String mainTableName;
		private String mainTableAlias;
		private String mainTableColumn;
		private String joinedTablePropertyName;
		private String joinedTableName;
		private String joinedTableAlias;
		private String joinedTableColumn;

		public DMJoin()
		{
		}

		public String getMainTableName()
		{
			return mainTableName;
		}

		public void setMainTableName(String mainTableName)
		{
			this.mainTableName = mainTableName;
		}

		public String getMainTableAlias()
		{
			return mainTableAlias;
		}

		public void setMainTableAlias(String mainTableAlias)
		{
			this.mainTableAlias = mainTableAlias;
		}

		public String getMainTableColumn()
		{
			return mainTableColumn;
		}

		public void setMainTableColumn(String mainTableColumn)
		{
			this.mainTableColumn = mainTableColumn;
		}

		public String getJoinedTableName()
		{
			return joinedTableName;
		}

		public void setJoinedTableName(String joinedTableName)
		{
			this.joinedTableName = joinedTableName;
		}

		public String getJoinedTableAlias()
		{
			return joinedTableAlias;
		}

		public void setJoinedTableAlias(String joinedTableAlias)
		{
			this.joinedTableAlias = joinedTableAlias;
		}

		public String getJoinedTableColumn()
		{
			return joinedTableColumn;
		}

		public void setJoinedTableColumn(String joinedTableColumn)
		{
			this.joinedTableColumn = joinedTableColumn;
		}

		public String getJoinedTablePropertyName()
		{
			return joinedTablePropertyName;
		}

		public void setJoinedTablePropertyName(String joinedTablePropertyName)
		{
			this.joinedTablePropertyName = joinedTablePropertyName;
		}

		public String getMainTablePropertyName()
		{
			return mainTablePropertyName;
		}

		public void setMainTablePropertyName(String mainTablePropertyName)
		{
			this.mainTablePropertyName = mainTablePropertyName;
		}
	}


	public List<DMJoin> getJoins()
	{
		return joins;
	}

	public void setJoins(List<DMJoin> joins)
	{
		this.joins = joins;
	}

	public DMPropWithParent(DMContainer parent, DMProperty property, String prefixWith)
	{
		this.parent = parent.prefixWith(prefixWith);
		this.property = property.prefixWith(prefixWith);
		if (parent instanceof DMEntity)
			this.root= (DMEntity) parent.prefixWith(prefixWith);
	}

	public DMProperty getProperty()
	{
		return property;
	}

	public void setProperty(DMProperty property)
	{
		this.property = property;
	}

	public DMContainer getParent()
	{
		return parent;
	}

	public void setParent(DMContainer parent)
	{
		this.parent = parent;
	}

	public DMProperty getParentProperty()
	{
		return parentProperty;
	}

	public void setParentProperty(DMProperty parentProperty)
	{
		this.parentProperty = parentProperty;
	}

	@Override
	public String toString()
	{
		String prop = property == null ? "" : ", property=" + property.getFullName();
		return "DMPropWithParent{" + prop + ", parent=" + parent.getTableName() + '}';
	}

	public DMEntity getRoot()
	{
		return root;
	}

	public void setRoot(DMEntity root)
	{
		this.root = root;
	}
}
