package com.namasoft.common.utils.importer.data;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.importer.parser.ImportDataManager;

import jakarta.xml.bind.annotation.*;
import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DetailEntryRow extends NaMaDTO
{
	private int row;
	private List<FieldValue> columns = new ArrayList<>();
	private ImportDataManager source;
	private String sheet;
	private Integer lineNumber;
	private String uniqueBy;
	private List<String> errors;

	public DetailEntryRow()
	{
	}

	public DetailEntryRow(int row, ImportDataManager input)
	{
		this();
		setRow(row);
		this.source = input;
		if (input != null)
		{
			this.lineNumber = input.currentLineNumber();
			this.sheet = input.currentSheet();
		}
	}

	public int getRow()
	{
		return row;
	}

	public void setRow(int row)
	{
		this.row = row;
	}

	public List<FieldValue> getColumns()
	{
		return columns;
	}

	public void setColumns(List<FieldValue> columns)
	{
		this.columns = columns;
	}

	@Override
	public String toString()
	{
		StringBuilder toStr = new StringBuilder();
		toStr.append(getRow()).append(":");
		toStr.append(StringUtils.toCSVLine(getColumns().toArray()));
		return toStr.toString();
	}

	@XmlTransient
	public ImportDataManager getSource()
	{
		return source;
	}

	public void setSource(ImportDataManager source)
	{
		this.source = source;
	}

	public String getSheet()
	{
		return sheet;
	}

	public void setSheet(String sheet)
	{
		this.sheet = sheet;
	}

	public Integer getLineNumber()
	{
		return lineNumber;
	}

	public void setLineNumber(Integer lineNumber)
	{
		this.lineNumber = lineNumber;
	}

	public String getUniqueBy()
	{
		return uniqueBy;
	}

	public void setUniqueBy(String uniqueBy)
	{
		this.uniqueBy = uniqueBy;
	}

	public List<String> getErrors()
	{
		return errors;
	}

	public void setErrors(List<String> errors)
	{
		this.errors = errors;
	}

	public void mergeWith(DetailEntryRow source)
	{
		for (FieldValue sourceColumn : source.getColumns())
		{
			FieldValue targetColumn = getColumns().stream().filter(ObjectChecker.equalsPredicate(sourceColumn.getId(), FieldValue::getId)).findFirst()
					.orElse(null);
			if (targetColumn == null)
				getColumns().add(sourceColumn);
			else
				targetColumn.mergeWith(sourceColumn);
		}
	}

	public String fetchFieldValue(String fieldId)
	{
		return getColumns().stream().filter(ObjectChecker.equalsPredicate(fieldId, FieldValue::getId)).map(FieldValue::getValue).findFirst()
				.orElse(null);
	}

	public boolean anyColumnHasValue()
	{
		return getColumns().stream().map(FieldValue::getValue).anyMatch(ObjectChecker::isNotEmptyOrNull);
	}

	public boolean areAllColumnsEmpty()
	{
		return !anyColumnHasValue();
	}

	public void addError(String e)
	{
		if(getErrors() == null)
			setErrors(new ArrayList<>());
		getErrors().add(e);
	}
}
