package com.namasoft.common.utils.importer.parser;

import com.namasoft.common.Pair;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.layout.metadata.NaMaMetaData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.importer.data.DataRecord;

import java.io.File;
import java.util.List;
import java.util.zip.ZipFile;

public interface RecordImportHelper<T>
{
	boolean isAdd();

	default boolean isAdd(DataRecord record)
	{
		if (ObjectChecker.isTrue(record.getDoNotAddRecords()))
			return false;
		return isAdd();
	}

	boolean isUpdate();

	default boolean isUpdate(DataRecord record)
	{
		if (ObjectChecker.isTrue(record.getDoNotUpdateRecords()))
			return false;
		return isUpdate();
	}

	boolean isIgnoreUnfoundRefs();

	boolean isContinueOnErrors();

	boolean isTrimExtraSpaces();

	T finish(List<NaMaError> errors);

	T finish(T result);

	Object findByID(String entiityType, String id);

	Object getFile(Pair<File, String> file);

	Object findRefByBusinessCode(String entityType, String code);

	String saveDraft(FlatObject object);

	String saveAndCommit(FlatObject object);

	Object findByBusinessCode(String entity, String code);

	T success();

	T failure(List<NaMaError> allErrors);

	Object createNew(String entity);

	NaMaMetaData getEntityMetada(String entity);

	boolean isSaveAsDraft();

	default boolean isSaveAsDraft(DataRecord record)
	{
		if (record.getSaveAsDraft() != null)
			return record.getSaveAsDraft();
		return isSaveAsDraft();
	}

	ZipFile getAttachments();

	String evaluateValue(String value);

	boolean shouldReceiveException(Exception e);

	boolean isAddToCurrentLines();
}
