package com.namasoft.common.utils.tafqeet;

import com.namasoft.common.utilities.*;
import com.namasoft.common.utils.GeneralSettings;

import java.util.*;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CurrencyDetails
{
	private static final int DESCRIPTION = 0;
	private static final int CURRENCY_CODE = 1;
	private static final int IS_CURRENCY_NAME_FEMININE = 2;
	private static final int ENGLISH_CURRENCY_NAME = 3;
	private static final int ENGLISH_PLURAL_CURRENCY_NAME = 4;
	private static final int ENGLISH_CURRENCY_PART_NAME = 5;
	private static final int ENGLISH_PLURAL_CURRENCY_PART_NAME = 6;
	private static final int ARABIC1_CURRENCY_NAME = 7;
	private static final int ARABIC2_CURRENCY_NAME = 8;
	private static final int ARABIC310_CURRENCY_NAME = 9;
	private static final int ARABIC1199_CURRENCY_NAME = 10;
	private static final int ARABIC1_CURRENCY_PART_NAME = 11;
	private static final int ARABIC2_CURRENCY_PART_NAME = 12;
	private static final int ARABIC310_CURRENCY_PART_NAME = 13;
	private static final int ARABIC1199_CURRENCY_PART_NAME = 14;
	private static final int PART_PRECISION = 15;
	private static final int IS_CURRENCY_PART_NAME_FEMININE = 16;

	private String description;
	private String code;
	private boolean isCurrencyNameFeminine;
	private String englishCurrencyName;
	private String englishPluralCurrencyName;
	private String englishCurrencyPartName;
	private String englishPluralCurrencyPartName;
	private String arabic1CurrencyName;
	private String arabic2CurrencyName;
	private String arabic310CurrencyName;
	private String arabic1199CurrencyName;
	private String arabic1CurrencyPartName;
	private String arabic2CurrencyPartName;
	private String arabic310CurrencyPartName;
	private String arabic1199CurrencyPartName;
	private int partPrecision;
	private boolean isCurrencyPartNameFeminine;
	private static HashMap<String, CurrencyDetails> details;
	private static HashMap<String, CurrencyDetails> otherDetails = new HashMap<String, CurrencyDetails>();

	/**
	 * Used from global config
	 * 
	 * @param otherDetails
	 */
	public static void setOtherDetails(HashMap<String, CurrencyDetails> otherDetails)
	{
		CurrencyDetails.otherDetails = otherDetails;
	}

	public static CurrencyDetails get(String code)
	{
		setup();
		if (otherDetails != null && otherDetails.containsKey(code))
			return otherDetails.get(code);
		return details.get(code.toLowerCase());
	}

	private static void setup()
	{
		if (details == null)
		{
			details = new HashMap<>();
			List<String> currencyDetails = GeneralSettings.readCurrencyDetails();
			for (String line : currencyDetails)
			{
				if (ObjectChecker.isEmptyOrNull(line.trim()) || line.trim().startsWith("//"))
					continue;
				String[] parts = line.split(Pattern.quote(","));
				if (parts.length < IS_CURRENCY_PART_NAME_FEMININE + 1)
				{
					NaMaLogger.error("Line (" + line + ") is not a valid currency details line");
					continue;
				}
				try
				{
					CurrencyDetails detail = convertToLine(parts);
					details.put(detail.getCode().toLowerCase(), detail);
				}
				catch (Exception e)
				{
				}
			}

		}
	}

	public static CurrencyDetails convertToLine(String[] parts)
	{
		CurrencyDetails detail = new CurrencyDetails();
		detail.setArabic1199CurrencyName(parts[ARABIC1199_CURRENCY_NAME]);
		detail.setArabic1199CurrencyPartName(parts[ARABIC1199_CURRENCY_PART_NAME]);
		detail.setArabic1CurrencyName(parts[ARABIC1_CURRENCY_NAME]);
		detail.setArabic1CurrencyPartName(parts[ARABIC1_CURRENCY_PART_NAME]);
		detail.setArabic2CurrencyName(parts[ARABIC2_CURRENCY_NAME]);
		detail.setArabic2CurrencyPartName(parts[ARABIC2_CURRENCY_PART_NAME]);
		detail.setArabic310CurrencyName(parts[ARABIC310_CURRENCY_NAME]);
		detail.setArabic310CurrencyPartName(parts[ARABIC310_CURRENCY_PART_NAME]);
		detail.setCode(parts[CURRENCY_CODE]);
		detail.setCurrencyNameFeminine(bool(parts[IS_CURRENCY_NAME_FEMININE]));
		detail.setCurrencyPartNameFeminine(bool(parts[IS_CURRENCY_PART_NAME_FEMININE]));
		detail.setDescription(parts[DESCRIPTION]);
		detail.setEnglishCurrencyName(parts[ENGLISH_CURRENCY_NAME]);
		detail.setEnglishCurrencyPartName(parts[ENGLISH_CURRENCY_PART_NAME]);
		detail.setEnglishPluralCurrencyName(parts[ENGLISH_PLURAL_CURRENCY_NAME]);
		detail.setEnglishPluralCurrencyPartName(parts[ENGLISH_PLURAL_CURRENCY_PART_NAME]);
		detail.setPartPrecision(ObjectChecker.valueOfInteger(parts[PART_PRECISION]));
		return detail;
	}

	private static boolean bool(String string)
	{
		return ObjectChecker.isAnyEqualToFirst(string.toLowerCase(), "yes", "true");
	}

	public static String otherDetailsAsCSV()
	{
		if (ObjectChecker.isEmptyOrNull(otherDetails))
			return "";
		List<Map.Entry<String, CurrencyDetails>> entries = new ArrayList<>(otherDetails.entrySet());
		entries.sort(Map.Entry.comparingByKey());
		return entries.stream().map(Map.Entry::getValue).map(CurrencyDetails::toLine).collect(Collectors.joining("@#@"));
	}

	private String toLine()
	{
		Object[] parts = new Object[IS_CURRENCY_PART_NAME_FEMININE + 1];
		parts[ARABIC1199_CURRENCY_NAME] = getArabic1199CurrencyName();
		parts[ARABIC1199_CURRENCY_PART_NAME] = getArabic1199CurrencyPartName();
		parts[ARABIC1_CURRENCY_NAME] = getArabic1CurrencyName();
		parts[ARABIC1_CURRENCY_PART_NAME] = getArabic1CurrencyPartName();
		parts[ARABIC2_CURRENCY_NAME] = getArabic2CurrencyName();
		parts[ARABIC2_CURRENCY_PART_NAME] = getArabic2CurrencyPartName();
		parts[ARABIC310_CURRENCY_NAME] = getArabic310CurrencyName();
		parts[ARABIC310_CURRENCY_PART_NAME] = getArabic310CurrencyPartName();
		parts[CURRENCY_CODE] = getCode();
		parts[IS_CURRENCY_NAME_FEMININE] = isCurrencyNameFeminine();
		parts[IS_CURRENCY_PART_NAME_FEMININE] = isCurrencyPartNameFeminine();
		parts[DESCRIPTION] = getDescription();
		parts[ENGLISH_CURRENCY_NAME] = getEnglishCurrencyName();
		parts[ENGLISH_CURRENCY_PART_NAME] = getEnglishCurrencyPartName();
		parts[ENGLISH_PLURAL_CURRENCY_NAME] = getEnglishPluralCurrencyName();
		parts[ENGLISH_PLURAL_CURRENCY_PART_NAME] = getEnglishPluralCurrencyPartName();
		parts[PART_PRECISION] = getPartPrecision();
		return StringUtils.toCSVLine(parts);
	}

	public String getCode()
	{
		return code;
	}

	public void setCode(String code)
	{
		this.code = code;
	}

	public boolean isCurrencyNameFeminine()
	{
		return isCurrencyNameFeminine;
	}

	public void setCurrencyNameFeminine(boolean isCurrencyNameFeminine)
	{
		this.isCurrencyNameFeminine = isCurrencyNameFeminine;
	}

	public String getEnglishCurrencyName()
	{
		return englishCurrencyName;
	}

	public void setEnglishCurrencyName(String englishCurrencyName)
	{
		this.englishCurrencyName = englishCurrencyName;
	}

	public String getEnglishPluralCurrencyName()
	{
		return englishPluralCurrencyName;
	}

	public void setEnglishPluralCurrencyName(String englishPluralCurrencyName)
	{
		this.englishPluralCurrencyName = englishPluralCurrencyName;
	}

	public String getEnglishCurrencyPartName()
	{
		return englishCurrencyPartName;
	}

	public void setEnglishCurrencyPartName(String englishCurrencyPartName)
	{
		this.englishCurrencyPartName = englishCurrencyPartName;
	}

	public String getEnglishPluralCurrencyPartName()
	{
		return englishPluralCurrencyPartName;
	}

	public void setEnglishPluralCurrencyPartName(String englishPluralCurrencyPartName)
	{
		this.englishPluralCurrencyPartName = englishPluralCurrencyPartName;
	}

	public String getArabic1CurrencyName()
	{
		return arabic1CurrencyName;
	}

	public void setArabic1CurrencyName(String arabic1CurrencyName)
	{
		this.arabic1CurrencyName = arabic1CurrencyName;
	}

	public String getArabic2CurrencyName()
	{
		return arabic2CurrencyName;
	}

	public void setArabic2CurrencyName(String arabic2CurrencyName)
	{
		this.arabic2CurrencyName = arabic2CurrencyName;
	}

	public String getArabic310CurrencyName()
	{
		return arabic310CurrencyName;
	}

	public void setArabic310CurrencyName(String arabic310CurrencyName)
	{
		this.arabic310CurrencyName = arabic310CurrencyName;
	}

	public String getArabic1199CurrencyName()
	{
		return arabic1199CurrencyName;
	}

	public void setArabic1199CurrencyName(String arabic1199CurrencyName)
	{
		this.arabic1199CurrencyName = arabic1199CurrencyName;
	}

	public String getArabic1CurrencyPartName()
	{
		return arabic1CurrencyPartName;
	}

	public void setArabic1CurrencyPartName(String arabic1CurrencyPartName)
	{
		this.arabic1CurrencyPartName = arabic1CurrencyPartName;
	}

	public String getArabic2CurrencyPartName()
	{
		return arabic2CurrencyPartName;
	}

	public void setArabic2CurrencyPartName(String arabic2CurrencyPartName)
	{
		this.arabic2CurrencyPartName = arabic2CurrencyPartName;
	}

	public String getArabic310CurrencyPartName()
	{
		return arabic310CurrencyPartName;
	}

	public void setArabic310CurrencyPartName(String arabic310CurrencyPartName)
	{
		this.arabic310CurrencyPartName = arabic310CurrencyPartName;
	}

	public String getArabic1199CurrencyPartName()
	{
		return arabic1199CurrencyPartName;
	}

	public void setArabic1199CurrencyPartName(String arabic1199CurrencyPartName)
	{
		this.arabic1199CurrencyPartName = arabic1199CurrencyPartName;
	}

	public int getPartPrecision()
	{
		return partPrecision;
	}

	public void setPartPrecision(int partPrecision)
	{
		this.partPrecision = partPrecision;
	}

	public boolean isCurrencyPartNameFeminine()
	{
		return isCurrencyPartNameFeminine;
	}

	public void setCurrencyPartNameFeminine(boolean isCurrencyPartNameFeminine)
	{
		this.isCurrencyPartNameFeminine = isCurrencyPartNameFeminine;
	}

	public String getDescription()
	{
		return description;
	}

	public void setDescription(String description)
	{
		this.description = description;
	}

	public static void reset()
	{
		details = null;
	}

}
