package com.namasoft.common.utils.translation;

import java.util.*;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;

import com.namasoft.common.constants.Language;
import com.namasoft.common.utilities.ObjectChecker;

public class MessageTranslatorFromDB extends MessageTranslatorBase
{
	private Map<String, String> arabic = new ConcurrentHashMap<>();
	private Map<String, String> english = new ConcurrentHashMap< >();
	private Map<String, String> replacements = new ConcurrentHashMap< >();
	private long order;

	public MessageTranslatorFromDB(ConcurrentHashMap<String, String> arabic, ConcurrentHashMap<String, String> english, ConcurrentHashMap<String, String> replacements, long order)
	{
		super();
		this.arabic = arabic;
		this.english = english;
		this.replacements = replacements;
		this.order = order;
	}

	public MessageTranslatorFromDB()
	{
	}

	@Override
	public List<String> getKeys()
	{
		HashSet<String> keys = new HashSet<String>();
		keys.addAll(arabic.keySet());
		keys.addAll(english.keySet());
		return new ArrayList<String>(keys);
	}

	@Override
	public long getOrder()
	{
		return order;
	}

	@Override
	public void processRecursions(AggregatedMessageTranslator aggregatedTranslator)
	{
		this.aggregatedTranslator = aggregatedTranslator;
		processLang(arabic, Language.Arabic);
		processLang(english, Language.English);
	}

	@Override
	public void processReplacements(List<MessageTranslator> translators)
	{
		for (Entry<String, String> replacement : replacements.entrySet())
		{
			for (MessageTranslator translator : translators)
			{
				translator.replace(replacement.getKey(), replacement.getValue());
			}
		}
	}

	@Override
	public String translateMessage(Language lang, String key)
	{
		return map(lang).get(key);
	}

	private Map<String, String> map(Language lang)
	{
		return lang == Language.English ? english : arabic;
	}

	@Override
	public void replace(String key, String value)
	{
		for (Entry<String, String> entry : arabic.entrySet())
		{
			entry.setValue(ObjectChecker.toStringOrEmpty(entry.getValue())
					.replace(ObjectChecker.toStringOrEmpty(key), ObjectChecker.toStringOrEmpty(value)));
		}
		for (Entry<String, String> entry : english.entrySet())
		{
			entry.setValue(ObjectChecker.toStringOrEmpty(entry.getValue())
					.replace(ObjectChecker.toStringOrEmpty(key), ObjectChecker.toStringOrEmpty(value)));
		}
	}
}
