package com.namasoft.common.utils.translation;

import com.namasoft.common.utils.TomcatLibLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class TranslationsFixer_ErrorMessages
{
	public static void main(String[] args) throws IOException
	{
		TomcatLibLoader.loadTomcatLibIfNeeded();
		fix("ar");
		//		writeToFile(missing, "src/main/resources/text/cmn-fr-msg.properties");
		//		writeToFile(concatenationsAndReferences, "src/main/resources/text/cmn-fr-references.properties");
		//		MessageTranslatorFromFile mfgAr = MessageTranslatorFromFile
		//				.fromPhysicalFiles("src/main/resources/text/mfg-ar.properties", "src/main/resources/text/mfg-ar.properties", 1);
		//		MessageTranslatorFromFile mfgEn = MessageTranslatorFromFile
		//				.fromPhysicalFiles("src/main/resources/text/mfg-en.properties", "src/main/resources/text/mfg-en.properties", 1);
	}

	private static void fix(String lang) throws IOException
	{
		List<Integer> indices = new ArrayList<>();
		List<String> lines = new ArrayList<>();
		lines.addAll(FileUtils.readLines(new File("src/main/resources/text/cmn-" + lang + "-msg.properties")));
		MessageTranslatorFromFile.spacesReceiver = (i, line) -> {
			indices.add(i);
			lines.add(line);
		};
		MessageTranslatorFromFile fr = MessageTranslatorFromFile.fromPhysicalFiles("src/main/resources/text/mfg-" + lang + ".properties", null, 1);
		lines.forEach(System.out::println);
		removeLines("src/main/resources/text/mfg-" + lang + ".properties", indices.toArray(new Integer[] {}));
		writeToFile(lines, "src/main/resources/text/cmn-" + lang + "-msg.properties");
	}

	private static void writeToFile(List<String> lines, String fileName) throws IOException
	{
		lines.sort(Comparator.naturalOrder());
		FileWriter writer = new FileWriter(fileName);
		IOUtils.writeLines(lines, "\n", writer);
		writer.close();
	}

	private static void removeLines(String file, Integer[] indices) throws IOException
	{
		List list = IOUtils.readLines(new FileInputStream(file), "utf-8");
		Arrays.sort(indices);
		for (int i = indices.length - 1; i >= 0; i--)
			list.remove(indices[i] - 1);
		FileOutputStream os = new FileOutputStream(file);
		IOUtils.writeLines(list, "\n", os, "utf-8");
		os.close();
	}
}
