package com.namasoft.common.utils.translation;

import com.namasoft.common.constants.Language;

public interface TranslatorHelper
{
	public static class TranslationHelperResult
	{
		public final boolean handled;
		public final String translation;

		private TranslationHelperResult(boolean handled, String translation)
		{
			this.handled = handled;
			this.translation = translation;
		}

		public static TranslationHelperResult notHandled()
		{
			return new TranslationHelperResult(false, null);
		}

		public static TranslationHelperResult handled(String translation)
		{
			return new TranslationHelperResult(true, translation);
		}
	}

	TranslationHelperResult translate(Language lang, Object arg);

	Language getCurrentLanguage();

}
