package com.namasoft.specialserialization;

import com.namasoft.common.utilities.ObjectChecker;

import java.util.*;

public class FixRemovedLineNumbers
{
	/**
	 * select i.id,ul.lineNumber,ul.id
	 * --delete ul
	 * from InvItem i inner join PrimaryConversionLine ul on ul.invItem_id = i.id
	 * inner join EntitySystemEntry e on e.targetId = i.id
	 * where e.code <> i.code
	 * order by i.id,ul.lineNumber
	 */
	public static void main(String[] args)
	{
		String[] lines = s.split("\n");
		Map<String, Integer> map = new HashMap<>();
		for (String line : lines)
		{
			String[] parts = line.split("\t");
			Integer lastNumber = map.computeIfAbsent(parts[0], k -> -1);
			Integer currentLineNumber = Integer.parseInt(parts[1]);
			if (ObjectChecker.areNotEqual(currentLineNumber, lastNumber))
				System.out.println("Update " + tableName + " set lineNumber = " + (currentLineNumber = lastNumber + 1) + " where id = " + parts[2]);
			map.put(parts[0], currentLineNumber);
		}
	}

	private static String tableName = "PrimaryConversionLine";

	private static String s = "0xFFFF00016346379D0E000000FF726783\t0\t0xFFFF00016346379D9B004700FF6B9C68\n"
			+ "0xFFFF00016346379D0E000000FF726783\t1\t0xFFFF00016346379D9B004900FF477E4E\n"
			+ "0xFFFF00016346379E85001A00FF2C9F01\t0\t0xFFFF00016346379EE3004700FF33E1B3\n"
			+ "0xFFFF00016346379E85001A00FF2C9F01\t1\t0xFFFF00016346379EE3004900FF73E4A2\n"
			+ "0xFFFF00016346379FEC001200FF2AE9EF\t0\t0xFFFF0001634637A069003800FF2C4A96\n"
			+ "0xFFFF00016346379FEC001200FF2AE9EF\t1\t0xFFFF0001634637A069003A00FF453066\n"
			+ "0xFFFF0001634637A163000F00FF3E6D99\t0\t0xFFFF0001634637A1C1004700FF6F3CB8\n"
			+ "0xFFFF0001634637A163000F00FF3E6D99\t2\t0xFFFF0001634637A1C1004B00FF445216\n"
			+ "0xFFFF0001634637A8A7001A00FF4DB8A2\t0\t0xFFFF0001634637A905004700FF22D5C2\n"
			+ "0xFFFF0001634637A8A7001A00FF4DB8A2\t1\t0xFFFF0001634637A905004900FF0C81B4\n"
			+ "0xFFFF0001634637AA0E000000FF6C8E5E\t0\t0xFFFF0001634637AA62000D00FF6CBEFE\n"
			+ "0xFFFF0001634637AA0E000000FF6C8E5E\t1\t0xFFFF0001634637AA62000F00FF1E4C6C\n"
			+ "0xFFFF0001634637AC87001A00FF3311BD\t0\t0xFFFF0001634637ACE5004700FF18BE56\n"
			+ "0xFFFF0001634637AC87001A00FF3311BD\t1\t0xFFFF0001634637ACE5004900FF381678\n"
			+ "0xFFFF0001634637ADCF001900FF1CDDB8\t0\t0xFFFF0001634637AE3D004700FF004B82\n"
			+ "0xFFFF0001634637ADCF001900FF1CDDB8\t1\t0xFFFF0001634637AE3D004900FF6F0295\n"
			+ "0xFFFF0001634637AF27001A00FF191288\t0\t0xFFFF0001634637AF94004700FF29EF15\n"
			+ "0xFFFF0001634637AF27001A00FF191288\t1\t0xFFFF0001634637AF94004900FF2C21FA\n"
			+ "0xFFFF0001634637B07F001A00FF16CBC0\t0\t0xFFFF0001634637B0DD004700FF468E44\n"
			+ "0xFFFF0001634637B07F001A00FF16CBC0\t1\t0xFFFF0001634637B0DD004900FF383B66\n"
			+ "0xFFFF0001634637B225003600FF174F58\t0\t0xFFFF0001634637B293004600FF7BF2E9\n"
			+ "0xFFFF0001634637B225003600FF174F58\t1\t0xFFFF0001634637B293004800FF1A640D\n"
			+ "0xFFFF0001634637B39C001A00FF249D14\t0\t0xFFFF0001634637B3FA004700FF6EA768\n"
			+ "0xFFFF0001634637B39C001A00FF249D14\t1\t0xFFFF0001634637B3FA004900FF197167\n"
			+ "0xFFFF0001634637B5A0001A00FF18EE80\t0\t0xFFFF0001634637B64C000900FF2EC5DB\n"
			+ "0xFFFF0001634637B5A0001A00FF18EE80\t1\t0xFFFF0001634637B64C000B00FF750BDA\n"
			+ "0xFFFF0001634637BB0F001A00FF099495\t0\t0xFFFF0001634637BB6C004700FF0C9F8D\n"
			+ "0xFFFF0001634637BB0F001A00FF099495\t2\t0xFFFF0001634637BB6C004B00FF3B04D2\n"
			+ "0xFFFF0001634637BC57001A00FF6AC11E\t0\t0xFFFF0001634637BD03004700FF249B70\n"
			+ "0xFFFF0001634637BC57001A00FF6AC11E\t1\t0xFFFF0001634637BD03004900FF2C775A\n"
			+ "0xFFFF0001634637BDFD000B00FF0BEFF4\t0\t0xFFFF0001634637BE5A003B00FF6DA3A8\n"
			+ "0xFFFF0001634637BDFD000B00FF0BEFF4\t1\t0xFFFF0001634637BE5A003D00FF635B23\n"
			+ "0xFFFF0001634637CBD0001A00FF2E637E\t0\t0xFFFF0001634637CC3E004700FF6F58D8\n"
			+ "0xFFFF0001634637CBD0001A00FF2E637E\t2\t0xFFFF0001634637CC3E004B00FF09FD98\n"
			+ "0xFFFF0001634637CD28001200FF6A775A\t0\t0xFFFF0001634637CD86003E00FF1F741F\n"
			+ "0xFFFF0001634637CD28001200FF6A775A\t2\t0xFFFF0001634637CD86004200FF185BA5\n"
			+ "0xFFFF0001634637CE61001A00FF16B3FF\t0\t0xFFFF0001634637CECE002D00FF50234A\n"
			+ "0xFFFF0001634637CE61001A00FF16B3FF\t1\t0xFFFF0001634637CECE002F00FF441530\n"
			+ "0xFFFF0001634637CFB9000D00FF5F9791\t0\t0xFFFF0001634637D045004000FF43627A\n"
			+ "0xFFFF0001634637CFB9000D00FF5F9791\t2\t0xFFFF0001634637D045004400FF06D2D2\n"
			+ "0xFFFF0001634637D120000F00FF22E7A8\t0\t0xFFFF0001634637D18D003900FF34533E\n"
			+ "0xFFFF0001634637D120000F00FF22E7A8\t2\t0xFFFF0001634637D18D003D00FF431343\n"
			+ "0xFFFF0001634637D7A2000100FF0DAD75\t0\t0xFFFF0001634637D800003300FF1CB6F5\n"
			+ "0xFFFF0001634637D7A2000100FF0DAD75\t2\t0xFFFF0001634637D800003700FF038A0B\n"
			+ "0xFFFF0001634637DA42001800FF7756AE\t1\t0xFFFF0001634637DAAF004200FF6BE8E1\n"
			+ "0xFFFF0001634637DA42001800FF7756AE\t2\t0xFFFF0001634637DAAF004400FF335A24\n"
			+ "0xFFFF0001634637DBA9001A00FF2A0FFF\t1\t0xFFFF0001634637DC07004900FF0E86EE\n"
			+ "0xFFFF0001634637DBA9001A00FF2A0FFF\t2\t0xFFFF0001634637DC07004B00FF799A3E\n"
			+ "0xFFFF0001634637DCE2001A00FF5F69E6\t0\t0xFFFF0001634637DD4F004700FF160D4E\n"
			+ "0xFFFF0001634637DCE2001A00FF5F69E6\t2\t0xFFFF0001634637DD4F004B00FF135D5C\n"
			+ "0xFFFF000163463809CD001200FF7BBA28\t0\t0xFFFF00016346380A4A004700FF7542BA\n"
			+ "0xFFFF000163463809CD001200FF7BBA28\t2\t0xFFFF00016346380A4A004B00FF17718F\n"
			+ "0xFFFF00016346380B54001A00FF002F87\t0\t0xFFFF00016346380BC1004700FF7C1664\n"
			+ "0xFFFF00016346380B54001A00FF002F87\t2\t0xFFFF00016346380BC1004B00FF4194BC\n"
			+ "0xFFFF00016346380CBB001A00FF7C632A\t0\t0xFFFF00016346380D38003800FF5115D9\n"
			+ "0xFFFF00016346380CBB001A00FF7C632A\t2\t0xFFFF00016346380D38003C00FF020877\n"
			+ "0xFFFF00016346380E51001100FF59C1BF\t0\t0xFFFF00016346380EBF002D00FF3FAD9C\n"
			+ "0xFFFF00016346380E51001100FF59C1BF\t2\t0xFFFF00016346380EBF003100FF0BB8A2\n"
			+ "0xFFFF00016346380F99001A00FF6771DD\t0\t0xFFFF00016346381007003800FF5BE143\n"
			+ "0xFFFF00016346380F99001A00FF6771DD\t2\t0xFFFF00016346381007003C00FF079C8E\n"
			+ "0xFFFF000163463810F1001A00FF0BFDAA\t0\t0xFFFF0001634638114F004700FF6D296A\n"
			+ "0xFFFF000163463810F1001A00FF0BFDAA\t2\t0xFFFF0001634638114F004B00FF6D8933\n"
			+ "0xFFFF00016346381D30000F00FF042FEA\t0\t0xFFFF00016346381D83001200FF3774CD\n"
			+ "0xFFFF00016346381D30000F00FF042FEA\t1\t0xFFFF00016346381D83001400FF225B85\n"
			+ "0xFFFF00016346381E5E001200FF661680\t0\t0xFFFF00016346381EBC003800FF1153AB\n"
			+ "0xFFFF00016346381E5E001200FF661680\t1\t0xFFFF00016346381EBC003A00FF0218D4\n"
			+ "0xFFFF00016346381F96000F00FF1F477F\t0\t0xFFFF00016346381FF4003100FF38347C\n"
			+ "0xFFFF00016346381F96000F00FF1F477F\t1\t0xFFFF00016346381FF4003300FF7DA6E5\n"
			+ "0xFFFF000163463820CF001A00FF5CC4E9\t0\t0xFFFF0001634638212D003800FF13483F\n"
			+ "0xFFFF000163463820CF001A00FF5CC4E9\t1\t0xFFFF0001634638212D003A00FF704DB8\n"
			+ "0xFFFF00016346382207001A00FF356CBC\t0\t0xFFFF000163463822A4001E00FF0BCEF3\n"
			+ "0xFFFF00016346382207001A00FF356CBC\t1\t0xFFFF000163463822A4002000FF74C4CD\n"
			+ "0xFFFF00016346382F60000D00FF410B62\t0\t0xFFFF00016346382FBE002A00FF06C22A\n"
			+ "0xFFFF00016346382F60000D00FF410B62\t2\t0xFFFF00016346382FBE002E00FF4521EF\n"
			+ "0xFFFF00016346383099001200FF470EB6\t0\t0xFFFF000163463830F7002F00FF39F976\n"
			+ "0xFFFF00016346383099001200FF470EB6\t2\t0xFFFF000163463830F7003300FF5A0AD3\n"
			+ "0xFFFF000163463831D2001500FF33414C\t0\t0xFFFF0001634638322F004700FF4705EC\n"
			+ "0xFFFF000163463831D2001500FF33414C\t2\t0xFFFF0001634638322F004B00FF70C401\n"
			+ "0xFFFF0001634638330A001100FF2B86A5\t0\t0xFFFF00016346383368002D00FF12E720\n"
			+ "0xFFFF0001634638330A001100FF2B86A5\t2\t0xFFFF00016346383368003100FF02E7CA\n"
			+ "0xFFFF00016346383443000D00FF46EFFB\t0\t0xFFFF000163463834A0004000FF6A24FC\n"
			+ "0xFFFF00016346383443000D00FF46EFFB\t2\t0xFFFF000163463834A0004400FF2C728A\n"
			+ "0xFFFF0001634638358B001200FF59E401\t0\t0xFFFF000163463835E8003800FF7552B9\n"
			+ "0xFFFF0001634638358B001200FF59E401\t2\t0xFFFF000163463835E8003C00FF6D73CC\n"
			+ "0xFFFF00016346383BEC000D00FF7BCF23\t0\t0xFFFF00016346383C3A004700FF72EFBB\n"
			+ "0xFFFF00016346383BEC000D00FF7BCF23\t2\t0xFFFF00016346383C3A004B00FF0DDEB1\n"
			+ "0xFFFF00016346383D15000F00FF24BA0C\t0\t0xFFFF00016346383D73004700FF46CCF9\n"
			+ "0xFFFF00016346383D15000F00FF24BA0C\t2\t0xFFFF00016346383D73004B00FF1CA682\n"
			+ "0xFFFF00016346383E4D001200FF78F84F\t0\t0xFFFF00016346383EAB004700FF41EF58\n"
			+ "0xFFFF00016346383E4D001200FF78F84F\t2\t0xFFFF00016346383EAB004B00FF2AF695\n"
			+ "0xFFFF00016346383F86001100FF617EEB\t0\t0xFFFF00016346383FE4004500FF25F3D9\n"
			+ "0xFFFF00016346383F86001100FF617EEB\t2\t0xFFFF00016346383FE4004900FF6B226A\n"
			+ "0xFFFF000163463840BD001A00FF7AF962\t0\t0xFFFF0001634638411A002A00FF5FB17D\n"
			+ "0xFFFF000163463840BD001A00FF7AF962\t2\t0xFFFF0001634638411A002E00FF210481\n"
			+ "0xFFFF00016346385C81001A00FF688977\t0\t0xFFFF00016346385CEF002800FF6B0088\n"
			+ "0xFFFF00016346385DBA000E00FF73BAAD\t0\t0xFFFF00016346385E18004200FF65B896\n"
			+ "0xFFFF00016346385EE3001A00FF1E71E1\t0\t0xFFFF00016346385F41002200FF5A7A90\n"
			+ "0xFFFF00016346385EE3001A00FF1E71E1\t2\t0xFFFF00016346385F41002600FF04A97A\n"
			+ "0xFFFF00016346386022000000FF5C9F86\t0\t0xFFFF00016346386091004800FF76D34D\n"
			+ "0xFFFF0001634638617B000D00FF060DB6\t0\t0xFFFF000163463861D9002B00FF63A474\n"
			+ "0xFFFF000163463862A4000D00FF03D7B9\t0\t0xFFFF000163463862F2001E00FF750B7E\n"
			+ "0xFFFF000163463863BE000D00FF6AEEF8\t0\t0xFFFF0001634638640C004800FF33FF19\n"
			+ "0xFFFF000163463864E6000D00FF374254\t0\t0xFFFF00016346386544002E00FF385332\n"
			+ "0xFFFF00016346386738001200FF280551\t0\t0xFFFF00016346386796004700FF5927C4\n"
			+ "0xFFFF00016346386738001200FF280551\t2\t0xFFFF00016346386796004B00FF2D1BC6\n"
			+ "0xFFFF00016346386885000F00FF0EE912\t0\t0xFFFF000163463868E3002E00FF778CD0\n"
			+ "0xFFFF00016346386885000F00FF0EE912\t2\t0xFFFF000163463868E3003200FF3ECB7A\n"
			+ "0xFFFF000163463869AE000D00FF02DC42\t0\t0xFFFF00016346386A0C003800FF48F7A2\n"
			+ "0xFFFF000163463869AE000D00FF02DC42\t2\t0xFFFF00016346386A0C003C00FF5D42FE\n"
			+ "0xFFFF00016346386AE7001A00FF7D40BC\t0\t0xFFFF00016346386B54001200FF209E45\n"
			+ "0xFFFF00016346386AE7001A00FF7D40BC\t2\t0xFFFF00016346386B54001600FF7D2BF3\n"
			+ "0xFFFF00016346386C4E001200FF60A600\t0\t0xFFFF00016346386CAC004600FF07C5BB\n"
			+ "0xFFFF00016346386C4E001200FF60A600\t2\t0xFFFF00016346386CAC004A00FF450CDA\n"
			+ "0xFFFF00016346386D96001A00FF5FC40E\t0\t0xFFFF00016346386DF4004700FF679302\n"
			+ "0xFFFF00016346386D96001A00FF5FC40E\t2\t0xFFFF00016346386DF4004B00FF747134\n"
			+ "0xFFFF00016346386ECF000B00FF097466\t0\t0xFFFF00016346386F2C002B00FF088C1C\n"
			+ "0xFFFF00016346386ECF000B00FF097466\t2\t0xFFFF00016346386F2C002F00FF795BFF\n"
			+ "0xFFFF00016346387046001A00FF3DB888\t0\t0xFFFF000163463870A3002B00FF139607\n"
			+ "0xFFFF00016346387046001A00FF3DB888\t2\t0xFFFF000163463870A3002F00FF6051BC\n"
			+ "0xFFFF0001634638717E000D00FF3CB0F4\t0\t0xFFFF000163463871DC003800FF1275C5\n"
			+ "0xFFFF0001634638717E000D00FF3CB0F4\t2\t0xFFFF000163463871DC003C00FF59D4EC\n"
			+ "0xFFFF0001634638B01B001A00FF5AED60\t0\t0xFFFF0001634638B098003800FF76713E\n"
			+ "0xFFFF0001634638B01B001A00FF5AED60\t1\t0xFFFF0001634638B098003A00FF13CB91\n"
			+ "0xFFFF0001634638B172001200FF30844E\t0\t0xFFFF0001634638B1D0003800FF2F1AFC\n"
			+ "0xFFFF0001634638B172001200FF30844E\t1\t0xFFFF0001634638B1D0003A00FF40468E\n"
			+ "0xFFFF0001634638B2AB000D00FF6B80D3\t0\t0xFFFF0001634638B2F9004700FF724670\n"
			+ "0xFFFF0001634638B2AB000D00FF6B80D3\t1\t0xFFFF0001634638B2F9004900FF51BAA1\n"
			+ "0xFFFF0001634638B3D4001A00FF4229EF\t0\t0xFFFF0001634638B441004700FF25FE40\n"
			+ "0xFFFF0001634638B3D4001A00FF4229EF\t2\t0xFFFF0001634638B441004B00FF6761DE\n"
			+ "0xFFFF0001634638B53B000E00FF4F4A00\t0\t0xFFFF0001634638B599003900FF439C9C\n"
			+ "0xFFFF0001634638B53B000E00FF4F4A00\t2\t0xFFFF0001634638B599003D00FF316D9A\n"
			+ "0xFFFF0001634638F682001700FF0A8F2A\t0\t0xFFFF0001634638F6E0004600FF04FCD9\n"
			+ "0xFFFF0001634638F682001700FF0A8F2A\t2\t0xFFFF0001634638F6E0004A00FF5BCA9F\n"
			+ "0xFFFF0001634638F7BB000F00FF751656\t0\t0xFFFF0001634638F838004700FF535AE5\n"
			+ "0xFFFF0001634638F7BB000F00FF751656\t2\t0xFFFF0001634638F838004B00FF2E6F5E\n"
			+ "0xFFFF0001634638F932001A00FF1C3047\t0\t0xFFFF0001634638F990004000FF7D1A72\n"
			+ "0xFFFF0001634638F932001A00FF1C3047\t2\t0xFFFF0001634638F990004400FF1E00C6\n"
			+ "0xFFFF0001634638FA6A001800FF348F0E\t0\t0xFFFF0001634638FAC8004700FF69C376\n"
			+ "0xFFFF0001634638FA6A001800FF348F0E\t2\t0xFFFF0001634638FAC8004B00FF6DA9BF\n"
			+ "0xFFFF000163463914C6001800FF5EB065\t0\t0xFFFF00016346391524004700FF329726\n"
			+ "0xFFFF000163463914C6001800FF5EB065\t2\t0xFFFF00016346391524004B00FF5C635E\n"
			+ "0xFFFF000163463915FE001A00FF14D8EE\t0\t0xFFFF0001634639165C004000FF67CF0C\n"
			+ "0xFFFF000163463915FE001A00FF14D8EE\t2\t0xFFFF0001634639165C004400FF51336B\n"
			+ "0xFFFF00016346391737001A00FF6D3F03\t0\t0xFFFF00016346391795003800FF5F3E28\n"
			+ "0xFFFF00016346391737001A00FF6D3F03\t2\t0xFFFF00016346391795003C00FF16656B\n"
			+ "0xFFFF0001634639187D001A00FF12E9D9\t0\t0xFFFF000163463918EB002700FF36CC95\n"
			+ "0xFFFF0001634639187D001A00FF12E9D9\t2\t0xFFFF000163463918EB002B00FF3A4F09\n"
			+ "0xFFFF000163463919C5001A00FF3B604A\t0\t0xFFFF00016346391A23003900FF6D4DA0\n"
			+ "0xFFFF000163463919C5001A00FF3B604A\t2\t0xFFFF00016346391A23003D00FF13B7E2\n"
			+ "0xFFFF00016346391AFE001A00FF575C5C\t0\t0xFFFF00016346391B5C002200FF510A99\n"
			+ "0xFFFF00016346391AFE001A00FF575C5C\t2\t0xFFFF00016346391B5C002600FF052E3F\n"
			+ "0xFFFF00016346391C36001A00FF4C8E72\t0\t0xFFFF00016346391C94003800FF02E604\n"
			+ "0xFFFF00016346391C36001A00FF4C8E72\t2\t0xFFFF00016346391C94003C00FF275AF4\n"
			+ "0xFFFF00016346391D6F001200FF619944\t0\t0xFFFF00016346391DCD001D00FF01C174\n"
			+ "0xFFFF00016346391D6F001200FF619944\t2\t0xFFFF00016346391DCD002100FF0DB610\n"
			+ "0xFFFF00016346391EA7001100FF59A863\t0\t0xFFFF00016346391F05002A00FF3BFDF3\n"
			+ "0xFFFF00016346391EA7001100FF59A863\t2\t0xFFFF00016346391F05002E00FF68586B\n"
			+ "0xFFFF0001634639201E000F00FF1BD777\t0\t0xFFFF0001634639207C003800FF606AB7\n"
			+ "0xFFFF0001634639201E000F00FF1BD777\t2\t0xFFFF0001634639207C003C00FF0EA52D\n"
			+ "0xFFFF0001634639248C001200FF3F89C8\t0\t0xFFFF000163463924EA004700FF755593\n"
			+ "0xFFFF0001634639248C001200FF3F89C8\t2\t0xFFFF000163463924EA004B00FF08F661\n"
			+ "0xFFFF000163463925E4001100FF59B26F\t0\t0xFFFF00016346392632002D00FF118472\n"
			+ "0xFFFF000163463925E4001100FF59B26F\t2\t0xFFFF00016346392632003100FF78A8B4\n"
			+ "0xFFFF0001634639270D000D00FF0CFE48\t0\t0xFFFF0001634639276B004700FF419821\n"
			+ "0xFFFF0001634639270D000D00FF0CFE48\t2\t0xFFFF0001634639276B004B00FF333D9B\n"
			+ "0xFFFF00016346392AC6001A00FF180F3E\t0\t0xFFFF00016346392B37000900FF052C17\n"
			+ "0xFFFF00016346392AC6001A00FF180F3E\t1\t0xFFFF00016346392B37000B00FF3D9A1F\n"
			+ "0xFFFF00016346392C12000E00FF70EA3B\t0\t0xFFFF00016346392C70003900FF6E624B\n"
			+ "0xFFFF00016346392C12000E00FF70EA3B\t1\t0xFFFF00016346392C70003B00FF35A45E\n"
			+ "0xFFFF00016346392D4B001900FF40429F\t0\t0xFFFF00016346392DA9004000FF44275C\n"
			+ "0xFFFF00016346392D4B001900FF40429F\t1\t0xFFFF00016346392DA9004200FF281F18\n"
			+ "0xFFFF00016346392E84001A00FF4D7167\t0\t0xFFFF00016346392EE1004600FF7ACBC2\n"
			+ "0xFFFF00016346392E84001A00FF4D7167\t1\t0xFFFF00016346392EE1004800FF6DB39D\n"
			+ "0xFFFF00016346392FBC001A00FF68CFB3\t0\t0xFFFF0001634639301A002D00FF6DFDC7\n"
			+ "0xFFFF00016346392FBC001A00FF68CFB3\t1\t0xFFFF0001634639301A002F00FF28F983\n"
			+ "0xFFFF000163463930F5001A00FF642EA6\t0\t0xFFFF00016346393152002900FF728E7C\n"
			+ "0xFFFF000163463930F5001A00FF642EA6\t1\t0xFFFF00016346393152002B00FF2AE6F6\n"
			+ "0xFFFF0001634639347F001200FF66E92B\t0\t0xFFFF000163463934DD004000FF440D96\n"
			+ "0xFFFF0001634639347F001200FF66E92B\t1\t0xFFFF000163463934DD004200FF15FAFC\n"
			+ "0xFFFF000163463935D7001A00FF5C62E0\t0\t0xFFFF00016346393634004700FF4AFC18\n"
			+ "0xFFFF000163463935D7001A00FF5C62E0\t1\t0xFFFF00016346393634004900FF189594\n"
			+ "0xFFFF00016346393719000000FF4AA9EF\t0\t0xFFFF00016346393757004700FF45ABA9\n"
			+ "0xFFFF00016346393719000000FF4AA9EF\t1\t0xFFFF00016346393757004900FF5A1A7C\n"
			+ "0xFFFF00016346393841000F00FF054595\t0\t0xFFFF0001634639389F002500FF234F0D\n"
			+ "0xFFFF00016346393841000F00FF054595\t1\t0xFFFF0001634639389F002700FF74B87D\n"
			+ "0xFFFF0001634639397A001A00FF38C83B\t0\t0xFFFF000163463939D8004000FF354774\n"
			+ "0xFFFF0001634639397A001A00FF38C83B\t1\t0xFFFF000163463939D8004200FF3FFCF4\n"
			+ "0xFFFF00016346393AB2000D00FF6E3E2C\t0\t0xFFFF00016346393B10002900FF02212A\n"
			+ "0xFFFF00016346393AB2000D00FF6E3E2C\t1\t0xFFFF00016346393B10002B00FF3FB697\n"
			+ "0xFFFF00016346393BF3000000FF6F4652\t0\t0xFFFF00016346393C42003600FF0EFCD4\n"
			+ "0xFFFF00016346393BF3000000FF6F4652\t1\t0xFFFF00016346393C42003800FF60C2B6\n"
			+ "0xFFFF00016346393D1D000F00FF0691EF\t0\t0xFFFF00016346393DB9004700FF3181CE\n"
			+ "0xFFFF00016346393D1D000F00FF0691EF\t1\t0xFFFF00016346393DB9004900FF293AA2\n"
			+ "0xFFFF00016346393EA4001A00FF40EAB6\t0\t0xFFFF00016346393F04004700FF6B1CA4\n"
			+ "0xFFFF00016346393EA4001A00FF40EAB6\t1\t0xFFFF00016346393F04004900FF775243\n"
			+ "0xFFFF00016346393FEF001100FF1F242E\t0\t0xFFFF0001634639404C003B00FF5E0920\n"
			+ "0xFFFF00016346393FEF001100FF1F242E\t1\t0xFFFF0001634639404C003D00FF53951C\n"
			+ "0xFFFF00016346394127001A00FF653A79\t0\t0xFFFF00016346394185004200FF01B3C6\n"
			+ "0xFFFF00016346394127001A00FF653A79\t1\t0xFFFF00016346394185004400FF6007D1\n"
			+ "0xFFFF00016346394260001200FF13BBDD\t0\t0xFFFF000163463942BD004000FF26AC8D\n"
			+ "0xFFFF00016346394260001200FF13BBDD\t1\t0xFFFF000163463942BD004200FF1437A8\n"
			+ "0xFFFF000163463943A8001A00FF3A2237\t0\t0xFFFF00016346394406002D00FF11E972\n"
			+ "0xFFFF000163463943A8001A00FF3A2237\t1\t0xFFFF00016346394406002F00FF460AC6\n"
			+ "0xFFFF000163463944E0001200FF1404AC\t0\t0xFFFF0001634639453E004600FF686947\n"
			+ "0xFFFF000163463944E0001200FF1404AC\t1\t0xFFFF0001634639453E004800FF4E8082\n"
			+ "0xFFFF00016346394619001A00FF48DB5D\t0\t0xFFFF00016346394677004700FF03EC20\n"
			+ "0xFFFF00016346394619001A00FF48DB5D\t1\t0xFFFF00016346394677004900FF18C6D7\n"
			+ "0xFFFF00016346394751001200FF331BDD\t0\t0xFFFF000163463947AF004700FF09DFE4\n"
			+ "0xFFFF00016346394751001200FF331BDD\t1\t0xFFFF000163463947AF004900FF1DB97A\n"
			+ "0xFFFF0001634639488A001A00FF431B3E\t0\t0xFFFF000163463948E8004700FF5B22CB\n"
			+ "0xFFFF0001634639488A001A00FF431B3E\t1\t0xFFFF000163463948E8004900FF4D8C7F\n"
			+ "0xFFFF000163463949E2001200FF1A5438\t0\t0xFFFF00016346394A3F003200FF697EAE\n"
			+ "0xFFFF000163463949E2001200FF1A5438\t1\t0xFFFF00016346394A3F003400FF12788A\n"
			+ "0xFFFF00016346394B28001200FF343949\t0\t0xFFFF00016346394B86004700FF6FC68B\n"
			+ "0xFFFF00016346394B28001200FF343949\t1\t0xFFFF00016346394B86004900FF6B83CE\n"
			+ "0xFFFF00016346394C70000F00FF466E9C\t0\t0xFFFF00016346394CCE003C00FF7EBA3B\n"
			+ "0xFFFF00016346394C70000F00FF466E9C\t1\t0xFFFF00016346394CCE003E00FF29822F\n"
			+ "0xFFFF00016346394DA9001100FF633C75\t0\t0xFFFF00016346394E07002800FF44ACB8\n"
			+ "0xFFFF00016346394DA9001100FF633C75\t1\t0xFFFF00016346394E07002A00FF5B1295\n"
			+ "0xFFFF00016346394EE1001A00FF685041\t0\t0xFFFF00016346394F4F004700FF73F8E7\n"
			+ "0xFFFF00016346394EE1001A00FF685041\t1\t0xFFFF00016346394F4F004900FF7A18FF\n"
			+ "0xFFFF00016346395039001200FF391F0B\t0\t0xFFFF00016346395097003800FF021BAF\n"
			+ "0xFFFF00016346395039001200FF391F0B\t1\t0xFFFF00016346395097003A00FF3614EA\n"
			+ "0xFFFF00016346395172001A00FF4DFF1B\t0\t0xFFFF000163463951CF003800FF089F92\n"
			+ "0xFFFF00016346395172001A00FF4DFF1B\t1\t0xFFFF000163463951CF003A00FF5C1995\n"
			+ "0xFFFF000163463952A5000D00FF6C7BF3\t0\t0xFFFF000163463952F4003300FF2F3005\n"
			+ "0xFFFF000163463952A5000D00FF6C7BF3\t1\t0xFFFF000163463952F4003500FF5D9815\n"
			+ "0xFFFF00016346395507001A00FF67677A\t0\t0xFFFF00016346395565002500FF3BC60C\n"
			+ "0xFFFF00016346395507001A00FF67677A\t1\t0xFFFF00016346395565002700FF2E64AD\n"
			+ "0xFFFF0001634639563F001A00FF3E82C2\t0\t0xFFFF0001634639569D003E00FF64BDEB\n"
			+ "0xFFFF0001634639563F001A00FF3E82C2\t1\t0xFFFF0001634639569D004000FF3D02D5\n"
			+ "0xFFFF00016346395778001A00FF58F04D\t0\t0xFFFF000163463957D6002800FF26D70F\n"
			+ "0xFFFF00016346395778001A00FF58F04D\t1\t0xFFFF000163463957D6002A00FF11A6E4\n"
			+ "0xFFFF000163463958B0000E00FF4D28DA\t0\t0xFFFF0001634639590E002B00FF4F72A5\n"
			+ "0xFFFF000163463958B0000E00FF4D28DA\t1\t0xFFFF0001634639590E002D00FF08AE66\n"
			+ "0xFFFF000163463959E9001A00FF2EDD0B\t0\t0xFFFF00016346395A47004700FF068FEC\n"
			+ "0xFFFF000163463959E9001A00FF2EDD0B\t1\t0xFFFF00016346395A47004900FF77E5C0\n"
			+ "0xFFFF00016346395B21001A00FF50E94B\t0\t0xFFFF00016346395B7F003800FF247EF0\n"
			+ "0xFFFF00016346395B21001A00FF50E94B\t1\t0xFFFF00016346395B7F003A00FF706948\n"
			+ "0xFFFF00016346395C79001200FF191EC8\t0\t0xFFFF00016346395CD7002300FF65C2E7\n"
			+ "0xFFFF00016346395C79001200FF191EC8\t1\t0xFFFF00016346395CD7002500FF7CEE5F\n"
			+ "0xFFFF00016346395DB2000F00FF651341\t0\t0xFFFF00016346395E13000900FF0C5408\n"
			+ "0xFFFF00016346395DB2000F00FF651341\t1\t0xFFFF00016346395E13000B00FF2165EC\n"
			+ "0xFFFF00016346395EEF001A00FF3D7BB1\t0\t0xFFFF00016346395F5C000F00FF1E4D43\n"
			+ "0xFFFF00016346395EEF001A00FF3D7BB1\t1\t0xFFFF00016346395F5C001100FF5B8252\n"
			+ "0xFFFF0001634639602C000000FF13ABC8\t0\t0xFFFF0001634639607A003900FF5DBB0E\n"
			+ "0xFFFF0001634639602C000000FF13ABC8\t1\t0xFFFF0001634639607A003B00FF7CEEEB\n"
			+ "0xFFFF00016346396155001200FF36C76D\t0\t0xFFFF000163463961C2002700FF6DB049\n"
			+ "0xFFFF00016346396155001200FF36C76D\t2\t0xFFFF000163463961C2002B00FF3B8A26\n"
			+ "0xFFFF0001634639629D001A00FF7D5A9A\t0\t0xFFFF000163463962FA004700FF3DDD37\n"
			+ "0xFFFF0001634639629D001A00FF7D5A9A\t2\t0xFFFF000163463962FA004B00FF005898\n"
			+ "0xFFFF000163463963D5000F00FF19BB38\t0\t0xFFFF00016346396433003500FF6B2D92\n"
			+ "0xFFFF000163463963D5000F00FF19BB38\t2\t0xFFFF00016346396433003900FF762BBF\n"
			+ "0xFFFF0001634639652D001A00FF2D14EA\t0\t0xFFFF0001634639658B003300FF6F8884\n"
			+ "0xFFFF0001634639652D001A00FF2D14EA\t2\t0xFFFF0001634639658B003700FF04745C\n"
			+ "0xFFFF0001634639666A001200FF3713B0\t0\t0xFFFF000163463966D8004700FF7639BF\n"
			+ "0xFFFF0001634639666A001200FF3713B0\t2\t0xFFFF000163463966D8004B00FF283320\n"
			+ "0xFFFF000163463967B2001A00FF11F2FC\t0\t0xFFFF00016346396810003900FF5882A7\n"
			+ "0xFFFF000163463967B2001A00FF11F2FC\t2\t0xFFFF00016346396810003D00FF1185D9\n"
			+ "0xFFFF00016346396913001A00FF33BDCA\t0\t0xFFFF00016346396971003800FF0942CA\n"
			+ "0xFFFF00016346396913001A00FF33BDCA\t2\t0xFFFF00016346396971003C00FF70795C\n"
			+ "0xFFFF00016A87D95633000C00FF2D42E3\t0\t0xFFFF00016A87D956CF000700FF71D6C8\n"
			+ "0xFFFF00016A87D95633000C00FF2D42E3\t2\t0xFFFF00016A87D956DF000100FF294A7A\n"
			+ "0xFFFF00016AEE21DFBE001600FF4CA7A7\t0\t0xFFFF00016AEE21E089000100FF1602B2\n"
			+ "0xFFFF00016AEE21DFBE001600FF4CA7A7\t2\t0xFFFF00016AEE22AAEE00C500135D7E5B\n"
			+ "0xFFFF00016B8EA9B49D000200FF173E06\t0\t0xFFFF00016B8EA9B51A000500FF0507F8\n"
			+ "0xFFFF00016B8EA9B49D000200FF173E06\t2\t0xFFFF00016C28C9261A00BC001342D82B\n"
			+ "0xFFFF00016C378F2718001700FF2D37ED\t0\t0xFFFF00016C378F27E3000100FF222E42\n"
			+ "0xFFFF00016C378F2718001700FF2D37ED\t2\t0xFFFF00016C3792135F00C600136BAD95\n"
			+ "0xFFFF00016C71122104000800FF730D6A\t0\t0xFFFF00016C71122171000900FF753DA2\n"
			+ "0xFFFF00016C71122104000800FF730D6A\t2\t0xFFFF00016C71122181000100FF721D0F\n"
			+ "0xFFFF00016E17352865000900FF1C0178\t0\t0xFFFF00016E17352940000300FF5E6695\n"
			+ "0xFFFF00016E17352865000900FF1C0178\t2\t0xFFFF00016E174CE5C600C600130CAB3A\n"
			+ "0xFFFF00016E1751B1EB001400FF4D688A\t0\t0xFFFF00016E1751B259002000FF2E09E4\n"
			+ "0xFFFF00016E1751B1EB001400FF4D688A\t2\t0xFFFF00016E1751B259002500FF7D8F3B\n"
			+ "0xFFFF00016E175712E6001600FF7D4C38\t0\t0xFFFF00016E17571392000600FF4A5169\n"
			+ "0xFFFF00016E175712E6001600FF7D4C38\t2\t0xFFFF00016E17571392000900FF058CD8\n"
			+ "0xFFFF00016E175A6C9C003600FF351378\t0\t0xFFFF00016E175A6D09005900FF1B6B67\n"
			+ "0xFFFF00016E175A6C9C003600FF351378\t2\t0xFFFF00016E175A6D19000000FF5B210D\n"
			+ "0xFFFF00016E175D8098000600FF5355CA\t0\t0xFFFF00016E175D811C000400FF1D9B5E\n"
			+ "0xFFFF00016E175D8098000600FF5355CA\t2\t0xFFFF00016E175D811F000100FF6ACA9F\n"
			+ "0xFFFF00016E175EC135001500FF743D95\t0\t0xFFFF00016E175EC1B2000A00FF2D3CE0\n"
			+ "0xFFFF00016E175EC135001500FF743D95\t2\t0xFFFF00016E175EC1C2000200FF619DE1\n"
			+ "0xFFFF00016E17633A10002E00FF55D99F\t0\t0xFFFF00016E17633A9D002600FF425FC8\n"
			+ "0xFFFF00016E17633A10002E00FF55D99F\t2\t0xFFFF00016E17633A9D002B00FF7B50EB\n"
			+ "0xFFFF00016E1765777A001300FF40263C\t0\t0xFFFF00016E176577F7000A00FF0887A6\n"
			+ "0xFFFF00016E1765777A001300FF40263C\t2\t0xFFFF00016E17657806000100FF597338\n"
			+ "0xFFFF00016E176970AC000000FF69EED7\t0\t0xFFFF00016E17697129001100FF7CDE55\n"
			+ "0xFFFF00016E176970AC000000FF69EED7\t2\t0xFFFF00016E174CE5C600C00013450B01\n"
			+ "0xFFFF00016E176CB66C000800FF46748D\t0\t0xFFFF00016E176CB6CA000A00FF089445\n"
			+ "0xFFFF00016E176CB66C000800FF46748D\t2\t0xFFFF00016E176CB6D9000200FF305A90\n"
			+ "0xFFFF00016E176D06BB000000FF134746\t0\t0xFFFF00016E176D0740000000FF1FAE88\n"
			+ "0xFFFF00016E176D06BB000000FF134746\t2\t0xFFFF00016E176D0744000000FF188D28\n"
			+ "0xFFFF00016E176DBEDB000000FF5D5777\t0\t0xFFFF00016E176DBF5D000600FF3EF984\n"
			+ "0xFFFF00016E176DBEDB000000FF5D5777\t2\t0xFFFF00016E176DBF60000100FF2E09FE\n"
			+ "0xFFFF00016E176EC472000700FF72B204\t0\t0xFFFF00016E176EC4FA000400FF45ED62\n"
			+ "0xFFFF00016E176EC472000700FF72B204\t2\t0xFFFF00016E176EC4FD000100FF45D509\n"
			+ "0xFFFF00016E176F9DFA000000FF164E09\t0\t0xFFFF00016E176F9E81000100FF748F23\n"
			+ "0xFFFF00016E176F9DFA000000FF164E09\t2\t0xFFFF00016E176F9E84000000FF736CFC\n"
			+ "0xFFFF00016E1779D785001300FF7A25DE\t0\t0xFFFF00016E1779D802000A00FF07D038\n"
			+ "0xFFFF00016E1779D785001300FF7A25DE\t2\t0xFFFF00016E1779D802000D00FF78BBE6\n"
			+ "0xFFFF0001700161B644001900FF2C0611\t1\t0xFFFF0001700144561B00C400137B92C7\n"
			+ "0xFFFF0001700161B644001900FF2C0611\t2\t0xFFFF0001700144561B00C30013389757\n"
			+ "0xFFFF0001700168DB8F001800FF1E13C3\t1\t0xFFFF0001700168DBCE000C00FF513D69\n"
			+ "0xFFFF0001700168DB8F001800FF1E13C3\t2\t0xFFFF0001700168DBCE000D00FF4E02BC\n"
			+ "0xFFFF000170E36147D4000B00FF3D7F04\t1\t0xFFFF000170E363114900C60013428A45\n"
			+ "0xFFFF000170E36147D4000B00FF3D7F04\t2\t0xFFFF000170E363114900C500135A90B9\n"
			+ "0xFFFF000171DA2718B6000700FF08CA94\t0\t0xFFFF000171DA271942000300FF3D1899\n"
			+ "0xFFFF000171DA2718B6000700FF08CA94\t2\t0xFFFF000171D94EA6E800C3001327E0A7\n"
			+ "0xFFFF000171DA3234CF001900FF091855\t0\t0xFFFF000171DA32355C000500FF0542AE\n"
			+ "0xFFFF000171DA3234CF001900FF091855\t2\t0xFFFF000171DA32355C000700FF3211D5\n"
			+ "0xFFFF000171DA3376C0002200FF05FDAC\t0\t0xFFFF000171DA33770E000300FF5C003D\n"
			+ "0xFFFF000171DA3376C0002200FF05FDAC\t2\t0xFFFF000171DA33770E000500FF0D8D84\n"
			+ "0xFFFF000171DA340D56000800FF5E4BFC\t0\t0xFFFF000171DA340DD3000500FF4C9BFF\n"
			+ "0xFFFF000171DA340D56000800FF5E4BFC\t2\t0xFFFF000171DA340DE2000000FF2BFDA6\n"
			+ "0xFFFF000171DA347EA8000D00FF42208D\t0\t0xFFFF000171DA347F35000300FF3811B0\n"
			+ "0xFFFF000171DA347EA8000D00FF42208D\t2\t0xFFFF000171DA347F35000500FF0BF2CF\n"
			+ "0xFFFF000171DA34D8C3000F00FF346609\t0\t0xFFFF000171DA34D94F000500FF17D1FF\n"
			+ "0xFFFF000171DA34D8C3000F00FF346609\t2\t0xFFFF000171DA34D94F000700FF297121\n"
			+ "0xFFFF000171DA37A62C000700FF67044B\t0\t0xFFFF000171DA37A6A9000500FF018783\n"
			+ "0xFFFF000171DA37A62C000700FF67044B\t2\t0xFFFF000171DA37A6B8000000FF7A77A3\n"
			+ "0xFFFF000171DA385536000300FF6DC72A\t0\t0xFFFF000171DA3855B3000800FF618092\n"
			+ "0xFFFF000171DA385536000300FF6DC72A\t2\t0xFFFF000171DA3855B3000A00FF2E6F69\n"
			+ "0xFFFF000171DA391023000200FF289C49\t0\t0xFFFF000171DA3910A0000500FF64EE78\n"
			+ "0xFFFF000171DA391023000200FF289C49\t2\t0xFFFF000171DA3910A0000700FF6A0400\n"
			+ "0xFFFF000171DA3A7617000000FF642206\t0\t0xFFFF000171DA3A7694000500FF6A59E6\n"
			+ "0xFFFF000171DA3A7617000000FF642206\t2\t0xFFFF000171DA3A7694000700FF67FBD0\n"
			+ "0xFFFF000171DA3E3DDC000000FF470A8B\t0\t0xFFFF000171DA3E3E59000500FF2412A8\n"
			+ "0xFFFF000171DA3E3DDC000000FF470A8B\t2\t0xFFFF000171DA3E3E59000700FF20A03E\n"
			+ "0xFFFF000171DA4038D0000B00FF4BFB75\t0\t0xFFFF000171DA40395D000100FF10B093\n"
			+ "0xFFFF000171DA4038D0000B00FF4BFB75\t2\t0xFFFF000171DA40395D000300FF4E62AA\n"
			+ "0xFFFF000171DA415E73000800FF643CBE\t0\t0xFFFF000171DA415EF0000500FF645F14\n"
			+ "0xFFFF000171DA415E73000800FF643CBE\t2\t0xFFFF000171DA415F00000000FF588EF6\n"
			+ "0xFFFF000171DA41E4B3000800FF3C81EB\t0\t0xFFFF000171DA41E530000500FF4F5AB9\n"
			+ "0xFFFF000171DA41E4B3000800FF3C81EB\t2\t0xFFFF000171DA41E530000700FF073C27\n"
			+ "0xFFFF000171DA42391E000800FF27D7E8\t0\t0xFFFF000171DA4239AB000400FF42ACAF\n"
			+ "0xFFFF000171DA42391E000800FF27D7E8\t2\t0xFFFF000171DA4239AB000600FF051B37\n"
			+ "0xFFFF000171DA47A70D000D00FF249808\t0\t0xFFFF000171DA47A78A000500FF3327D3\n"
			+ "0xFFFF000171DA47A70D000D00FF249808\t2\t0xFFFF000171DA47A78A000700FF78372A\n"
			+ "0xFFFF000171DA498255000800FF60A6D8\t0\t0xFFFF000171DA4982E1000000FF48E02B\n"
			+ "0xFFFF000171DA498255000800FF60A6D8\t2\t0xFFFF000171DA4982E1000200FF4B679B\n"
			+ "0xFFFF000171DA4AE3BD000A00FF66B2E3\t0\t0xFFFF000171DA4AE44A000300FF7A9D08\n"
			+ "0xFFFF000171DA4AE3BD000A00FF66B2E3\t2\t0xFFFF000171DA4AE44A000500FF2E97BE\n"
			+ "0xFFFF000171DA4BAAA5000800FF52AD1E\t0\t0xFFFF000171DA4BAB22000500FF71EC8D\n"
			+ "0xFFFF000171DA4BAAA5000800FF52AD1E\t2\t0xFFFF000171DA4BAB22000700FF67551E\n"
			+ "0xFFFF000171DA4C2BDA001500FF6C8FA2\t0\t0xFFFF000171DA4C2C67000500FF2B3325\n"
			+ "0xFFFF000171DA4C2BDA001500FF6C8FA2\t2\t0xFFFF000171DA4C2C67000700FF49D68A\n"
			+ "0xFFFF000171DA4ED09D000700FF7951EA\t0\t0xFFFF000171DA4ED11A000300FF5A08E8\n"
			+ "0xFFFF000171DA4ED09D000700FF7951EA\t2\t0xFFFF000171D94EA6E800C100131621C1";
}
