package com.namasoft.specialserialization;

import org.apache.commons.io.filefilter.TrueFileFilter;

import java.io.*;
import java.util.Locale;

public class FolderCleanupUtil
{
	public static void cleanFolder(File toClean, FileFilter filter)
	{
		if (!toClean.exists())
			return;
		File[] oldFilesAndEmptyDirs = toClean.listFiles(filter);
		if(oldFilesAndEmptyDirs == null)
			return;
		for (File file : oldFilesAndEmptyDirs)
		{
			if (!file.isFile())
				cleanFolder(file, filter);
			file.delete();
		}
	}

	public static void cleanFolderByNameFilter(File toClean, String fileNameContainsPattern)
	{
		if (!toClean.exists())
			return;
		File[] filesToDelete = toClean.listFiles(
				file -> file.isFile() && file.getName().toLowerCase().contains(fileNameContainsPattern.toLowerCase(Locale.ROOT)));
		for (File file : filesToDelete)
		{
			if (!file.isFile())
				cleanFolder(file, TrueFileFilter.TRUE);
			file.delete();
		}
	}
}
