package com.namasoft.specialserialization;

import com.namasoft.common.fieldids.RepDynamicFieldNames;
import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.util.List;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class ReportDetailsResponse
{
	private List<ReportBand> bands;
	private int pageWidth;
	private int pageHeight;
	private int topMargin;
	private int bottomMargin;
	private int leftMargin;
	private int rightMargin;

	public List<ReportBand> getBands()
	{
		return bands;
	}

	public void setBands(List<ReportBand> bands)
	{
		this.bands = bands;
	}

	public int getPageWidth()
	{
		return pageWidth;
	}

	public void setPageWidth(int pageWidth)
	{
		this.pageWidth = pageWidth;
	}

	public int getPageHeight()
	{
		return pageHeight;
	}

	public void setPageHeight(int pageHeight)
	{
		this.pageHeight = pageHeight;
	}

	public int getTopMargin()
	{
		return topMargin;
	}

	public void setTopMargin(int topMargin)
	{
		this.topMargin = topMargin;
	}

	public int getBottomMargin()
	{
		return bottomMargin;
	}

	public void setBottomMargin(int bottomMargin)
	{
		this.bottomMargin = bottomMargin;
	}

	public int getLeftMargin()
	{
		return leftMargin;
	}

	public void setLeftMargin(int leftMargin)
	{
		this.leftMargin = leftMargin;
	}

	public int getRightMargin()
	{
		return rightMargin;
	}

	public void setRightMargin(int rightMargin)
	{
		this.rightMargin = rightMargin;
	}

	public ReportBand fetchGroupHeaderBand(int index)
	{
		return getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.GROUP_HEADER + index)).findFirst()
				.orElse(null);
	}

	public ReportBand fetchGroupFooterBand(int index)
	{
		return getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.GROUP_FOOTER + index)).findFirst()
				.orElse(null);
	}

	public int fetchTitleBandHeight()
	{
		return ObjectChecker.toZeroIfNull(
				getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.TITLE_BAND)).findFirst()
						.map(ReportBand::getHeight).orElse(null));
	}

	public int fetchPageHeaderBandHeight()
	{
		return ObjectChecker.toZeroIfNull(
				getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.PAGE_HEADER_BAND)).findFirst()
						.map(ReportBand::getHeight).orElse(null));
	}

	public int fetchPageFooterBandHeight()
	{
		return ObjectChecker.toZeroIfNull(
				getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.PAGE_FOOTER_BAND)).findFirst()
						.map(ReportBand::getHeight).orElse(null));
	}

	public int fetchColumnHeaderBandHeight()
	{
		return ObjectChecker.toZeroIfNull(
				getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.COLUMN_HEADER_BAND)).findFirst()
						.map(ReportBand::getHeight).orElse(null));
	}

	public int fetchColumnHeaderBandHeightByIndex(int index)
	{
		return ObjectChecker.toZeroIfNull(
				getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.COLUMN_HEADER_BAND_BY_INDEX + index))
						.findFirst().map(ReportBand::getHeight).orElse(null));
	}

	public int fetchDetailBandHeight()
	{
		return ObjectChecker.toZeroIfNull(
				getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.DETAIL_BAND)).findFirst()
						.map(ReportBand::getHeight).orElse(null));
	}

	public int fetchDetailBandHeightByIndex(int index)
	{
		return ObjectChecker.toZeroIfNull(
				getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.DETAIL_BAND_BY_INDEX + index)).findFirst()
						.map(ReportBand::getHeight).orElse(null));
	}

	public int fetchSummaryBandHeight()
	{
		return ObjectChecker.toZeroIfNull(
				getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.SUMMARY_BAND)).findFirst()
						.map(ReportBand::getHeight).orElse(null));
	}

	public int fetchSummaryBandHeightByIndex(int index)
	{
		return ObjectChecker.toZeroIfNull(
				getBands().stream().filter(l -> ObjectChecker.areEqual(l.getName(), RepDynamicFieldNames.SUMMARY_BAND_BY_INDEX + index)).findFirst()
						.map(ReportBand::getHeight).orElse(null));
	}

	@XmlAccessorType(XmlAccessType.PROPERTY)
	public static class ReportBand
	{
		private List<ReportElement> elements;
		private String name;
		private int height;

		public String getName()
		{
			return name;
		}

		public void setName(String name)
		{
			this.name = name;
		}

		public int getHeight()
		{
			return height;
		}

		public void setHeight(int height)
		{
			this.height = height;
		}

		public List<ReportElement> getElements()
		{
			return elements;
		}

		public void setElements(List<ReportElement> elements)
		{
			this.elements = elements;
		}
	}

	@XmlAccessorType(XmlAccessType.PROPERTY)
	public static class ReportElement
	{
		private boolean blankWhenNull;
		private String textAdjust;
		private String stretchType;
		private String verticalTextAlign;
		private String horizontalTextAlign;
		private String mode;
		private String horizontalImageAlign;
		private String verticalImageAlign;
		private String onErrorType;
		private float borderWidth;
		private String borderColor;
		private String expression;
		private String arabicText;
		private String englishText;

		public String getArabicText()
		{
			return arabicText;
		}

		public void setArabicText(String arabicText)
		{
			this.arabicText = arabicText;
		}

		public String getEnglishText()
		{
			return englishText;
		}

		public void setEnglishText(String englishText)
		{
			this.englishText = englishText;
		}

		public String getExpression()
		{
			return expression;
		}

		public void setExpression(String expression)
		{
			this.expression = expression;
		}

		public boolean isBlankWhenNull()
		{
			return blankWhenNull;
		}

		public void setBlankWhenNull(boolean blankWhenNull)
		{
			this.blankWhenNull = blankWhenNull;
		}

		public String getTextAdjust()
		{
			return textAdjust;
		}

		public void setTextAdjust(String textAdjust)
		{
			this.textAdjust = textAdjust;
		}

		public String getStretchType()
		{
			return stretchType;
		}

		public void setStretchType(String stretchType)
		{
			this.stretchType = stretchType;
		}

		public String getVerticalTextAlign()
		{
			return verticalTextAlign;
		}

		public void setVerticalTextAlign(String verticalTextAlign)
		{
			this.verticalTextAlign = verticalTextAlign;
		}

		public String getHorizontalTextAlign()
		{
			return horizontalTextAlign;
		}

		public void setHorizontalTextAlign(String horizontalTextAlign)
		{
			this.horizontalTextAlign = horizontalTextAlign;
		}

		public String getMode()
		{
			return mode;
		}

		public void setMode(String mode)
		{
			this.mode = mode;
		}

		public String getHorizontalImageAlign()
		{
			return horizontalImageAlign;
		}

		public void setHorizontalImageAlign(String horizontalImageAlign)
		{
			this.horizontalImageAlign = horizontalImageAlign;
		}

		public String getVerticalImageAlign()
		{
			return verticalImageAlign;
		}

		public void setVerticalImageAlign(String verticalImageAlign)
		{
			this.verticalImageAlign = verticalImageAlign;
		}

		public String getOnErrorType()
		{
			return onErrorType;
		}

		public void setOnErrorType(String onErrorType)
		{
			this.onErrorType = onErrorType;
		}

		public float getBorderWidth()
		{
			return borderWidth;
		}

		public void setBorderWidth(float borderWidth)
		{
			this.borderWidth = borderWidth;
		}

		public String getBorderColor()
		{
			return borderColor;
		}

		public void setBorderColor(String borderColor)
		{
			this.borderColor = borderColor;
		}

		private int x;
		private int y;
		private int width;
		private int height;
		private float fontSize;
		private String backcolor;
		private String forecolor;
		private boolean bold;
		private String namaId;

		public String getNamaId()
		{
			return namaId;
		}

		public void setNamaId(String namaId)
		{
			this.namaId = namaId;
		}

		public boolean isBold()
		{
			return bold;
		}

		public void setBold(boolean bold)
		{
			this.bold = bold;
		}

		public int getX()
		{
			return x;
		}

		public void setX(int x)
		{
			this.x = x;
		}

		public int getY()
		{
			return y;
		}

		public void setY(int y)
		{
			this.y = y;
		}

		public int getWidth()
		{
			return width;
		}

		public void setWidth(int width)
		{
			this.width = width;
		}

		public int getHeight()
		{
			return height;
		}

		public void setHeight(int height)
		{
			this.height = height;
		}

		public float getFontSize()
		{
			return fontSize;
		}

		public void setFontSize(float fontSize)
		{
			this.fontSize = fontSize;
		}

		public String getBackcolor()
		{
			return backcolor;
		}

		public void setBackcolor(String backcolor)
		{
			this.backcolor = backcolor;
		}

		public String getForecolor()
		{
			return forecolor;
		}

		public void setForecolor(String forecolor)
		{
			this.forecolor = forecolor;
		}
	}

}
