package com.namasoft.specialserialization;

import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.*;

import java.io.*;

public class SimpleXMLMarshaller
{
	public static enum Format
	{
		Yes, No
	}

	public String marshal(Object object)
	{
		return marshal(object, Format.No);
	}

	public String marshal(Object object, Format formatEnabled)
	{
		if (object == null)
			return "";

		String xmlDF;
		StringWriter xml = new StringWriter();
		marshal(object, xml, formatEnabled);
		xmlDF = xml.toString();
		return xmlDF;
	}

	public void marshal(Object object, OutputStream stream)
	{
		marshal(object, stream, Format.No);
	}

	public void marshal(Object object, OutputStream stream, Format formatEnabled)
	{
		try
		{
			Marshaller m = prepareMarshaller(object, formatEnabled);
			m.marshal(object, stream);
		}
		catch (JAXBException e)
		{
			throw new RuntimeException("Can not create XML data", e);
		}
	}

	private void marshal(Object object, Writer writer, Format formatEnabled)
	{
		try
		{
			Marshaller m = prepareMarshaller(object, formatEnabled);
			m.marshal(object, writer);
		}
		catch (JAXBException e)
		{
			throw new RuntimeException("Can not create XML data", e);
		}
	}

	private Marshaller prepareMarshaller(Object object, Format formatEnabled) throws JAXBException
	{
		JAXBContext context = JAXBContext.newInstance(object.getClass());
		Marshaller m = context.createMarshaller();

		if (formatEnabled == Format.Yes)
			m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

		m.setProperty(Marshaller.JAXB_ENCODING, "UTF-8");
		return m;
	}

	public <T> T unmarshal(Class<T> klass, String xml)
	{
		if (ObjectChecker.isEmptyOrNull(xml))
			return null;

		try
		{
			T unmarshal = unmarshal(klass, new ByteArrayInputStream(xml.getBytes("UTF-8")));
			return unmarshal;
		}
		catch (UnsupportedEncodingException e)
		{
			throw new RuntimeException("XML is not UTF-8", e);
		}

	}

	public <T> T unmarshal(Class<T> klass, InputStream xmlReader)
	{
		try
		{
			JAXBContext context = JAXBContext.newInstance(klass);
			Unmarshaller u = context.createUnmarshaller();
			T returnedObject = (T) u.unmarshal(xmlReader);
			return returnedObject;
		}
		catch (JAXBException e)
		{
			throw new RuntimeException("Can not unmarshal the xml", e);
		}
	}

	public static SimpleXMLMarshaller getInstance()
	{
		return new SimpleXMLMarshaller();
	}

	public <T> T clone(T original)
	{
		String xml = marshal(original);
		return (T) unmarshal(original.getClass(), xml);
	}
}
