package com.namasoft.taxauthority;

import com.namasoft.taxauthority.ereceipt.*;

import jakarta.xml.bind.annotation.XmlSeeAlso;

@XmlSeeAlso({ TaxAuthorityInvoice.class, TaxAuthorityDebitNote.class, TaxAuthorityCreditNote.class, TaxAuthorityCancelDocument.class, EReceipt.class,
		EReturnReceipt.class, TaxAuthorityExportInvoice.class, TaxAuthorityExportDebitNote.class, TaxAuthorityExportCreditNote.class })
public abstract class AbsEgyptionEInvoice extends EInvoiceDoc
{
	@Override
	public EInvoiceCountry invoiceCountry()
	{
		return EInvoiceCountry.Egypt;
	}

	@Override
	public boolean hasDefaultTaxCurrency()
	{
		return false;
	}

	@Override
	public String defaultCurrency()
	{
		return "EGP";
	}

	@Override
	public String cashPaymentMethodCode()
	{
		return "C";
	}

	@Override
	public String otherPaymentMethodCode()
	{
		return "O";
	}
}
