package com.namasoft.taxauthority;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.taxauthority.ereceipt.EReceiptLine;
import com.namasoft.taxauthority.ksa.entities.ZATCAEInvoiceLine;

import jakarta.xml.bind.annotation.*;
import java.math.BigDecimal;
import java.util.List;

@XmlSeeAlso({ TaxAuthorityInvoiceLine.class, EReceiptLine.class, ZATCAEInvoiceLine.class })
public abstract class EInvoiceDocLine
{
	@JsonIgnore
	private Object originCurrency;

	@XmlTransient
	public Object getOriginCurrency()
	{
		return originCurrency;
	}

	public void setOriginCurrency(Object originCurrency)
	{
		this.originCurrency = originCurrency;
	}

	public abstract void setQuantity(BigDecimal quantity);

	public abstract BigDecimal getQuantity();

	public abstract void updateUnitPrice(TaxAuthorityUnitValue unitValue);

	public abstract void calcSalesTotal();

	public abstract void updateSalesTotal(BigDecimal salesTotal);

	public abstract BigDecimal fetchSalesTotal();

	public abstract void calcNetTotal();

	public abstract void updateNetTotal(BigDecimal salesTotal);

	public abstract BigDecimal fetchNetTotal();

	public abstract void calcTotal();

	public abstract void updateTotal(BigDecimal salesTotal);

	public abstract BigDecimal fetchFinalTotal();

	public abstract void updateUnitType(String unitType);

	public abstract void updateDiscount(TaxAuthorityDiscount discount);

	public abstract TaxAuthorityDiscount fetchDiscount();

	public abstract void updateTaxableItems(List<TaxAuthorityLineTax> taxableItems);

	public abstract List<TaxAuthorityLineTax> fetchTaxableItems();

	public abstract void updateTotalTaxableFees(BigDecimal totalTaxableFees);

	public abstract void updateItemsDiscount(BigDecimal itemsDiscount);

	public abstract void updateItemCode(String itemCode);

	public abstract String fetchItemCode();

	public abstract void updateItemType(String itemType);

	public abstract void updateInternalCode(String internalCode);

	public abstract void updateDescription(String description);

	public abstract BigDecimal fetchItemsDiscount();

	public abstract String fetchUnitType();

	public abstract String currencySold(EInvoiceDoc doc);
	public abstract BigDecimal currencyRate(EInvoiceDoc doc);

	@JsonIgnore
	public void updateNulls()
	{

	}

	public abstract String fetchItemType();

	public abstract String fetchDescription();

	public abstract String fetchInternalCode();

	public abstract BigDecimal fetchUnitPrice();

	public void updateWeightUnitType(String weightUnitType)
	{

	}

	public void updateWeightQuantity(BigDecimal weightQuantity)
	{

	}

	public String fetchWeightUnitType()
	{
		return null;
	}

	public BigDecimal fetchWeightQuantity()
	{
		return null;
	}

	public void updateLineIndex(int index){

	}
}
