package com.namasoft.taxauthority;

import com.namasoft.common.utilities.CollectionsUtility;

import jakarta.xml.bind.annotation.*;
import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlSeeAlso({ TaxAuthorityInvoice.class, TaxAuthorityDebitNote.class, TaxAuthorityCreditNote.class, TaxAuthorityCancelDocument.class })
public abstract class TaxAuthorityAbsNormalDocument extends TaxAuthorityDocument
{
	private TaxAuthorityIssuer issuer;
	private List<TaxAuthorityInvoiceLine> invoiceLines;

	public TaxAuthorityIssuer getIssuer()
	{
		return issuer;
	}

	public void setIssuer(TaxAuthorityIssuer issuer)
	{
		this.issuer = issuer;
	}

	public List<TaxAuthorityInvoiceLine> getInvoiceLines()
	{
		return invoiceLines;
	}

	public void setInvoiceLines(List<TaxAuthorityInvoiceLine> invoiceLines)
	{
		this.invoiceLines = invoiceLines;
	}

	@Override
	public void updateLines(List<? extends EInvoiceDocLine> lines)
	{
		setInvoiceLines(CollectionsUtility.castList(lines));
	}

	@Override
	public <T extends EInvoiceDocLine> List<T> fetchLines()
	{
		return CollectionsUtility.castList(lines());
	}

	public <T extends EInvoiceDocLine> List<T> lines()
	{
		if (getInvoiceLines() == null)
			setInvoiceLines(new ArrayList<>());
		return CollectionsUtility.castList(getInvoiceLines());
	}

	@Override
	public <T extends EInvoiceDocLine> void addLine(T line)
	{
		lines().add(line);
	}

	@Override
	public TaxAuthorityEntityWithAddress fetchIssuer()
	{
		return getIssuer();
	}

	@Override
	public void updateIssuer(TaxAuthorityEntityWithAddress issuer)
	{
		setIssuer((TaxAuthorityIssuer) issuer);
	}
}