package com.namasoft.taxauthority;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.xml.bind.annotation.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TaxAuthorityAddress
{
	private String country;
	private String governate;
	private String regionCity;
	private String street;
	private String buildingNumber;
	private String postalCode;
	private String floor;
	private String room;
	private String landmark;
	private String additionalInformation;
	private String district;

	public String getCountry()
	{
		return country;
	}

	public void setCountry(String country)
	{
		this.country = country;
	}

	public String getGovernate()
	{
		return governate;
	}

	public void setGovernate(String governate)
	{
		this.governate = governate;
	}

	public String getRegionCity()
	{
		return regionCity;
	}

	public void setRegionCity(String regionCity)
	{
		this.regionCity = regionCity;
	}

	public String getStreet()
	{
		return street;
	}

	public void setStreet(String street)
	{
		this.street = street;
	}

	public String getBuildingNumber()
	{
		return buildingNumber;
	}

	public void setBuildingNumber(String buildingNumber)
	{
		this.buildingNumber = buildingNumber;
	}

	public String getPostalCode()
	{
		return postalCode;
	}

	public void setPostalCode(String postalCode)
	{
		this.postalCode = postalCode;
	}

	public String getFloor()
	{
		return floor;
	}

	public void setFloor(String floor)
	{
		this.floor = floor;
	}

	public String getRoom()
	{
		return room;
	}

	public void setRoom(String room)
	{
		this.room = room;
	}

	public String getLandmark()
	{
		return landmark;
	}

	public void setLandmark(String landmark)
	{
		this.landmark = landmark;
	}

	public String getAdditionalInformation()
	{
		return additionalInformation;
	}

	public void setAdditionalInformation(String additionalInformation)
	{
		this.additionalInformation = additionalInformation;
	}

	@JsonIgnore
	public String getDistrict()
	{
		return district;
	}

	public void setDistrict(String district)
	{
		this.district = district;
	}

	public void copyFrom(TaxAuthorityAddress address)
	{
		country = address.country;
		governate = address.governate;
		regionCity = address.regionCity;
		street = address.street;
		buildingNumber = address.buildingNumber;
		postalCode = address.postalCode;
		floor = address.floor;
		room = address.room;
		landmark = address.landmark;
		additionalInformation = address.additionalInformation;
		district = address.district;
	}

	public void updateBranchId(String branchId)
	{

	}

	public String fetchBranchId()
	{
		return null;
	}
}