package com.namasoft.taxauthority;

import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TaxAuthorityDelivery
{
	private String approach;
	private String packaging;
	private String dateValidity;
	private String exportPort;
	private String countryOfOrigin;
	private String terms;
	private Double grossWeight;
	private Double netWeight;

	public String getApproach()
	{
		return approach;
	}

	public void setApproach(String approach)
	{
		this.approach = approach;
	}

	public String getPackaging()
	{
		return packaging;
	}

	public void setPackaging(String packaging)
	{
		this.packaging = packaging;
	}

	public String getDateValidity()
	{
		return dateValidity;
	}

	public void setDateValidity(String dateValidity)
	{
		this.dateValidity = dateValidity;
	}

	public String getExportPort()
	{
		return exportPort;
	}

	public void setExportPort(String exportPort)
	{
		this.exportPort = exportPort;
	}

	public String getCountryOfOrigin()
	{
		return countryOfOrigin;
	}

	public void setCountryOfOrigin(String countryOfOrigin)
	{
		this.countryOfOrigin = countryOfOrigin;
	}

	public String getTerms()
	{
		return terms;
	}

	public void setTerms(String terms)
	{
		this.terms = terms;
	}

	public Double getGrossWeight()
	{
		return grossWeight;
	}

	public void setGrossWeight(Double grossWeight)
	{
		this.grossWeight = grossWeight;
	}

	public Double getNetWeight()
	{
		return netWeight;
	}

	public void setNetWeight(Double netWeight)
	{
		this.netWeight = netWeight;
	}

	public boolean ifEmpty()
	{
		return ObjectChecker.areAllEmptyOrNull(getApproach(), getPackaging(), getDateValidity(), getExportPort(), getCountryOfOrigin(), getTerms())
				&& ObjectChecker.areAllEmptyOrZero(getGrossWeight(), getNetWeight());
	}

}