package com.namasoft.taxauthority;

import com.namasoft.common.utilities.ObjectChecker;

import jakarta.xml.bind.annotation.*;
import java.math.BigDecimal;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TaxAuthorityDiscount
{
	private BigDecimal rate;
	private BigDecimal amount;

	public BigDecimal getRate()
	{
		return rate;
	}

	public void setRate(BigDecimal rate)
	{
		this.rate = rate;
	}

	public BigDecimal getAmount()
	{
		return amount;
	}

	public void setAmount(BigDecimal amount)
	{
		this.amount = amount;
	}

	public void updateNulls()
	{
		rate = ObjectChecker.toZeroIfNull(rate);
		amount = ObjectChecker.toZeroIfNull(amount);
	}
}