package com.namasoft.taxauthority;

import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlSeeAlso({ TaxAuthorityInvoice.class, TaxAuthorityDebitNote.class, TaxAuthorityCreditNote.class, TaxAuthorityCancelDocument.class,
		TaxAuthorityExportInvoice.class, TaxAuthorityExportDebitNote.class, TaxAuthorityExportCreditNote.class })
public abstract class TaxAuthorityDocument extends AbsEgyptionEInvoice
{
	private String documentType;
	private String documentTypeVersion;
	private String dateTimeIssued;
	private String taxpayerActivityCode;
	private String internalID;
	private String purchaseOrderReference;
	private String purchaseOrderDescription;
	private String salesOrderReference;
	private String salesOrderDescription;
	private String proformaInvoiceNumber;
	private BigDecimal totalSalesAmount;
	private BigDecimal totalDiscountAmount;
	private BigDecimal netAmount;
	private BigDecimal extraDiscountAmount;
	private BigDecimal totalItemsDiscountAmount;
	private BigDecimal totalAmount;
	private TaxAuthorityReceiver receiver;
	private TaxAuthorityPayment payment;
	private TaxAuthorityDelivery delivery;
	private List<TaxAuthoritySignature> signatures;

	public String getInternalID()
	{
		return internalID;
	}

	public void setInternalID(String internalID)
	{
		this.internalID = internalID;
	}

	public String getDocumentType()
	{
		return documentType;
	}

	public void setDocumentType(String documentType)
	{
		this.documentType = documentType;
	}

	public String getDocumentTypeVersion()
	{
		return documentTypeVersion;
	}

	public void setDocumentTypeVersion(String documentTypeVersion)
	{
		this.documentTypeVersion = documentTypeVersion;
	}

	public String  getDateTimeIssued()
	{
		return dateTimeIssued;
	}

	public void setDateTimeIssued(String  dateTimeIssued)
	{
		this.dateTimeIssued = dateTimeIssued;
	}

	public String getTaxpayerActivityCode()
	{
		return taxpayerActivityCode;
	}

	public void setTaxpayerActivityCode(String taxpayerActivityCode)
	{
		this.taxpayerActivityCode = taxpayerActivityCode;
	}

	public String getPurchaseOrderReference()
	{
		return purchaseOrderReference;
	}

	public void setPurchaseOrderReference(String purchaseOrderReference)
	{
		this.purchaseOrderReference = purchaseOrderReference;
	}

	public String getPurchaseOrderDescription()
	{
		return purchaseOrderDescription;
	}

	public void setPurchaseOrderDescription(String purchaseOrderDescription)
	{
		this.purchaseOrderDescription = purchaseOrderDescription;
	}

	public String getSalesOrderReference()
	{
		return salesOrderReference;
	}

	public void setSalesOrderReference(String salesOrderReference)
	{
		this.salesOrderReference = salesOrderReference;
	}

	public String getSalesOrderDescription()
	{
		return salesOrderDescription;
	}

	public void setSalesOrderDescription(String salesOrderDescription)
	{
		this.salesOrderDescription = salesOrderDescription;
	}

	public String getProformaInvoiceNumber()
	{
		return proformaInvoiceNumber;
	}

	public void setProformaInvoiceNumber(String proformaInvoiceNumber)
	{
		this.proformaInvoiceNumber = proformaInvoiceNumber;
	}

	public BigDecimal getTotalSalesAmount()
	{
		return totalSalesAmount;
	}

	public void setTotalSalesAmount(BigDecimal totalSalesAmount)
	{
		this.totalSalesAmount = totalSalesAmount;
	}

	public BigDecimal getTotalDiscountAmount()
	{
		return totalDiscountAmount;
	}

	public void setTotalDiscountAmount(BigDecimal totalDiscountAmount)
	{
		this.totalDiscountAmount = totalDiscountAmount;
	}

	public BigDecimal getNetAmount()
	{
		return netAmount;
	}

	public void setNetAmount(BigDecimal netAmount)
	{
		this.netAmount = netAmount;
	}

	public BigDecimal getExtraDiscountAmount()
	{
		return extraDiscountAmount;
	}

	public void setExtraDiscountAmount(BigDecimal extraDiscountAmount)
	{
		this.extraDiscountAmount = extraDiscountAmount;
	}

	public BigDecimal getTotalItemsDiscountAmount()
	{
		return totalItemsDiscountAmount;
	}

	public void setTotalItemsDiscountAmount(BigDecimal totalItemsDiscountAmount)
	{
		this.totalItemsDiscountAmount = totalItemsDiscountAmount;
	}

	public BigDecimal getTotalAmount()
	{
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount)
	{
		this.totalAmount = totalAmount;
	}

	public TaxAuthorityReceiver getReceiver()
	{
		return receiver;
	}

	public void setReceiver(TaxAuthorityReceiver receiver)
	{
		this.receiver = receiver;
	}

	public TaxAuthorityPayment getPayment()
	{
		return payment;
	}

	public void setPayment(TaxAuthorityPayment payment)
	{
		this.payment = payment;
	}

	public TaxAuthorityDelivery getDelivery()
	{
		return delivery;
	}

	public void setDelivery(TaxAuthorityDelivery delivery)
	{
		this.delivery = delivery;
	}

	public List<TaxAuthoritySignature> getSignatures()
	{
		return signatures;
	}

	public void setSignatures(List<TaxAuthoritySignature> signatures)
	{
		this.signatures = signatures;
	}

	@Override
	public void updateTotalSalesAmount(BigDecimal totalSalesAmount)
	{
		setTotalSalesAmount(totalSalesAmount);
	}

	@Override
	public void updateTotalDiscountAmount(BigDecimal totalDiscountAmount)
	{
		setTotalDiscountAmount(totalDiscountAmount);
	}

	@Override
	public BigDecimal fetchTotalDiscountAmount()
	{
		return getTotalDiscountAmount();
	}

	@Override
	public void updateNetAmount(BigDecimal netAmount)
	{
		setNetAmount(netAmount);
	}

	@Override
	public void updateExtraDiscountAmount(BigDecimal extraDiscountAmount)
	{
		setExtraDiscountAmount(extraDiscountAmount);
	}

	@Override
	public void updateTotalItemsDiscountAmount(BigDecimal totalItemsDiscountAmount)
	{
		setTotalItemsDiscountAmount(totalItemsDiscountAmount);
	}

	@Override
	public BigDecimal fetchTotalItemsDiscountAmount()
	{
		return getTotalItemsDiscountAmount();
	}

	@Override
	public BigDecimal fetchExtraDiscountAmount()
	{
		return getExtraDiscountAmount();
	}

	public String receiverType()
	{
		return type(getReceiver());
	}

	public String issuerType()
	{
		return type(fetchIssuer());
	}

	private String type(TaxAuthorityEntityWithAddress entity)
	{
		if (entity == null)
			return "";
		if (ObjectChecker.areEqual("B", entity.getType()))
			return "Business";
		if (ObjectChecker.areEqual("P", entity.getType()))
			return "Person";
		if (ObjectChecker.areEqual("F", entity.getType()))
			return "Foreigner";
		return "";
	}

	public String receiverAddress()
	{
		return address(getReceiver());
	}

	public String issuerAddress()
	{
		return address(fetchIssuer());
	}

	private String address(TaxAuthorityEntityWithAddress entity)
	{
		if (entity == null)
			return "";
		TaxAuthorityAddress address = entity.address();
		if (address == null)
			return "";
		StringBuilder builder = new StringBuilder();
		builder.append(address.getBuildingNumber()).append("\n");
		builder.append(address.getStreet()).append("\n");
		builder.append(address.getRegionCity()).append(", ").append(address.getGovernate()).append(", ").append(address.getCountry());
		return builder.toString();
	}

	@Override
	public void updateDocumentVersion(boolean signed)
	{
		setDocumentTypeVersion(signed ? "1.0" : "0.9");
	}

	@Override
	public void updateTaxpayerActivityCode(String activityCode)
	{
		setTaxpayerActivityCode(activityCode);
	}

	@Override
	public void updateDateTimeIssued(String dateTimeIssued)
	{
		setDateTimeIssued(dateTimeIssued);
	}

	@Override
	public String fetchDateTimeIssued()
	{
		return getDateTimeIssued();
	}

	@Override
	public void updateDelivery(TaxAuthorityDelivery delivery)
	{
		if (delivery == null || delivery.ifEmpty())
			setDelivery(null);
		else
			setDelivery(delivery);
	}

	@Override
	public TaxAuthorityDelivery fetchDelivery()
	{
		return getDelivery();
	}

	@Override
	public void updateReceiver(TaxAuthorityReceiver receiver)
	{
		setReceiver(receiver);
	}

	@Override
	public TaxAuthorityReceiver fetchReceiver()
	{
		return getReceiver();
	}

	@Override
	public void updatePayment(TaxAuthorityPayment payment)
	{
		if (payment == null || payment.ifEmpty())
			setPayment(null);
		else
			setPayment(payment);
	}

	@Override
	public TaxAuthorityPayment fetchPayment()
	{
		return getPayment();
	}

	@Override
	public void updatePurchaseOrderReference(String purchaseOrderReference)
	{
		setPurchaseOrderReference(purchaseOrderReference);
	}

	@Override
	public void updatePurchaseOrderDescription(String purchaseOrderDescription)
	{
		setPurchaseOrderDescription(purchaseOrderDescription);
	}

	@Override
	public void updateSalesOrderReference(String salesOrderReference)
	{
		setSalesOrderReference(salesOrderReference);
	}

	@Override
	public void updateSalesOrderDescription(String salesOrderDescription)
	{
		setSalesOrderDescription(salesOrderDescription);
	}

	@Override
	public String fetchSalesOrderDescription()
	{
		return getSalesOrderDescription();
	}

	@Override
	public void updateProformaInvoiceNumber(String proformaInvoiceNumber)
	{
		setProformaInvoiceNumber(proformaInvoiceNumber);
	}

	@Override
	public void updateInternalCode(String internalCode)
	{
		setInternalID(internalCode);
	}

	@Override
	public String fetchInternalCode()
	{
		return getInternalID();
	}

	@Override
	public boolean documentVersionRequireSignature()
	{
		return ObjectChecker.areEqual(getDocumentTypeVersion(), "1.0");
	}

	@Override
	public boolean shouldValidateSignature()
	{
		return documentVersionRequireSignature();
	}

	@Override
	public BigDecimal fetchTotalSalesAmount()
	{
		return getTotalSalesAmount();
	}

	@Override
	public BigDecimal fetchNetAmount()
	{
		return getNetAmount();
	}

	@Override
	public boolean shouldCheckReceiverAddress()
	{
		return ObjectChecker.areEqual(getReceiver().getType(), "B");
	}

	@Override
	public <T extends EInvoiceDocLine> T createLine()
	{
		return (T) new TaxAuthorityInvoiceLine();
	}

	@Override
	public BigDecimal fetchFinalTotalAmount()
	{
		return getTotalAmount();
	}

	@Override
	public void updateFinalTotalAmount(BigDecimal totalAmount)
	{
		setTotalAmount(totalAmount);
	}
}