package com.namasoft.taxauthority;

import com.fasterxml.jackson.annotation.JsonIgnore;

import jakarta.xml.bind.annotation.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TaxAuthorityExportIssuer extends TaxAuthorityEntityWithAddress
{
	private TaxAuthorityExportIssuerAddress address;

	public TaxAuthorityExportIssuer()
	{
		this.address = new TaxAuthorityExportIssuerAddress();
	}

	public TaxAuthorityExportIssuerAddress getAddress()
	{
		return address;
	}

	public void setAddress(TaxAuthorityExportIssuerAddress address)
	{
		this.address = address;
	}

	@Override
	@JsonIgnore
	public TaxAuthorityAddress address()
	{
		return getAddress();
	}
}