package com.namasoft.taxauthority;

import jakarta.xml.bind.annotation.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TaxAuthorityExportIssuerAddress extends TaxAuthorityAddress
{
	private String branchID;

	public String getBranchID()
	{
		return branchID;
	}

	public void setBranchID(String branchID)
	{
		this.branchID = branchID;
	}

	@Override
	public void copyFrom(TaxAuthorityAddress address)
	{
		super.copyFrom(address);
		if (!(address instanceof TaxAuthorityExportIssuerAddress))
			return;
		this.branchID = ((TaxAuthorityExportIssuerAddress) address).branchID;
	}

	@Override
	public void updateBranchId(String branchId)
	{
		setBranchID(branchId);
	}

	@Override
	public String fetchBranchId()
	{
		return getBranchID();
	}
}