package com.namasoft.taxauthority;

import com.fasterxml.jackson.annotation.JsonIgnore;

import jakarta.xml.bind.annotation.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TaxAuthorityIssuer extends TaxAuthorityEntityWithAddress
{
	private TaxAuthorityIssuerAddress address;

	public TaxAuthorityIssuer()
	{
		this.address = new TaxAuthorityIssuerAddress();
	}

	public TaxAuthorityIssuerAddress getAddress()
	{
		return address;
	}

	public void setAddress(TaxAuthorityIssuerAddress address)
	{
		this.address = address;
	}

	@Override
	@JsonIgnore
	public TaxAuthorityAddress address()
	{
		return getAddress();
	}
}