package com.namasoft.taxauthority;

import com.namasoft.common.utilities.*;

import jakarta.xml.bind.annotation.*;
import java.util.List;
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class TaxAuthorityTotalTax extends TaxAuthorityTax
{
	public TaxAuthorityTotalTax()
	{
	}

	public static void addAmountToTotalIfNeeded(List<TaxAuthorityTotalTax> totals, TaxAuthorityLineTax lineTax)
	{
		TaxAuthorityTotalTax totalTax = totals.stream().filter(l -> ObjectChecker.areEqual(lineTax.getTaxType(), l.getTaxType())).findFirst()
				.orElse(null);
		if (totalTax == null)
		{
			totalTax = new TaxAuthorityTotalTax();
			totals.add(totalTax);
		}
		totalTax.setTaxType(lineTax.getTaxType());
		totalTax.addToAmountFromLine(lineTax);
	}

	public void addToAmountFromLine(TaxAuthorityLineTax lineTax)
	{
		setAmount(NaMaMath.zeroIfNull(getAmount()));
		lineTax.setAmount(NaMaMath.zeroIfNull(lineTax.getAmount()));
		setAmount(NaMaMath.sum(getAmount(), lineTax.getAmount()));
	}
}