package com.namasoft.taxauthority.ereceipt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.namasoft.common.utilities.*;
import com.namasoft.taxauthority.*;

import jakarta.xml.bind.annotation.*;
import java.math.BigDecimal;
import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlSeeAlso({ EReceipt.class, EReturnReceipt.class })
public abstract class EgyptAbsEReceipt extends AbsEgyptionEInvoice
{
	private EReceiptHeader header;
	private EReceiptDocumentType documentType;
	private EReceiptSeller seller;
	private EReceiptBuyer buyer;
	private EReceiptContractor contractor;
	private EReceiptBeneficiary beneficiary;
	private BigDecimal totalSales;
	private BigDecimal totalCommercialDiscount;
	private BigDecimal totalItemsDiscount;
	private BigDecimal netAmount;
	private BigDecimal feesAmount;
	private BigDecimal totalAmount;
	private BigDecimal adjustment;
	private String paymentMethod;
	private List<EReceiptDiscount> extraReceiptDiscountData;
	private List<EReceiptLine> itemData;

	@JsonIgnore
	private List<TaxAuthoritySignature> signatures;

	public EReceiptHeader getHeader()
	{
		return header;
	}

	public void setHeader(EReceiptHeader header)
	{
		this.header = header;
	}

	public EReceiptDocumentType getDocumentType()
	{
		return documentType;
	}

	public void setDocumentType(EReceiptDocumentType documentType)
	{
		this.documentType = documentType;
	}

	public EReceiptSeller getSeller()
	{
		return seller;
	}

	public void setSeller(EReceiptSeller seller)
	{
		this.seller = seller;
	}

	public EReceiptBuyer getBuyer()
	{
		return buyer;
	}

	public void setBuyer(EReceiptBuyer buyer)
	{
		this.buyer = buyer;
	}

	public EReceiptContractor getContractor()
	{
		return contractor;
	}

	public void setContractor(EReceiptContractor contractor)
	{
		this.contractor = contractor;
	}

	public EReceiptBeneficiary getBeneficiary()
	{
		return beneficiary;
	}

	public void setBeneficiary(EReceiptBeneficiary beneficiary)
	{
		this.beneficiary = beneficiary;
	}

	public BigDecimal getTotalSales()
	{
		return totalSales;
	}

	public void setTotalSales(BigDecimal totalSales)
	{
		this.totalSales = totalSales;
	}

	public BigDecimal getTotalCommercialDiscount()
	{
		return totalCommercialDiscount;
	}

	public void setTotalCommercialDiscount(BigDecimal totalCommercialDiscount)
	{
		this.totalCommercialDiscount = totalCommercialDiscount;
	}

	public BigDecimal getTotalItemsDiscount()
	{
		return totalItemsDiscount;
	}

	public void setTotalItemsDiscount(BigDecimal totalItemsDiscount)
	{
		this.totalItemsDiscount = totalItemsDiscount;
	}

	public BigDecimal getNetAmount()
	{
		return netAmount;
	}

	public void setNetAmount(BigDecimal netAmount)
	{
		this.netAmount = netAmount;
	}

	public BigDecimal getFeesAmount()
	{
		return feesAmount;
	}

	public void setFeesAmount(BigDecimal feesAmount)
	{
		this.feesAmount = feesAmount;
	}

	public BigDecimal getTotalAmount()
	{
		return totalAmount;
	}

	public void setTotalAmount(BigDecimal totalAmount)
	{
		this.totalAmount = totalAmount;
	}

	public BigDecimal getAdjustment()
	{
		return adjustment;
	}

	public void setAdjustment(BigDecimal adjustment)
	{
		this.adjustment = adjustment;
	}

	public String getPaymentMethod()
	{
		return paymentMethod;
	}

	public void setPaymentMethod(String paymentMethod)
	{
		this.paymentMethod = paymentMethod;
	}

	public List<EReceiptDiscount> getExtraReceiptDiscountData()
	{
		return extraReceiptDiscountData;
	}

	public void setExtraReceiptDiscountData(List<EReceiptDiscount> extraReceiptDiscountData)
	{
		this.extraReceiptDiscountData = extraReceiptDiscountData;
	}

	public List<EReceiptLine> getItemData()
	{
		return itemData;
	}

	public void setItemData(List<EReceiptLine> itemData)
	{
		this.itemData = itemData;
	}

	@Override
	public void updateDocumentVersion(boolean signed)
	{
		EReceiptDocumentType documentType = getDocumentType();
		if (documentType == null)
			setDocumentType(documentType = new EReceiptDocumentType());
		documentType.setTypeVersion("1.2");
		documentType.setReceiptType(fetchType());
	}

	public EReceiptSeller seller()
	{
		if (getSeller() == null)
			setSeller(new EReceiptSeller());
		return getSeller();
	}

	public EReceiptBuyer buyer()
	{
		if (getBuyer() == null)
			setBuyer(new EReceiptBuyer());
		return getBuyer();
	}

	public EReceiptHeader header()
	{
		if (getHeader() == null)
			setHeader(new EReceiptHeader());
		return getHeader();
	}

	public abstract String fetchType();

	@Override
	public void updateTaxpayerActivityCode(String activityCode)
	{
		seller().setActivityCode(activityCode);
	}

	@Override
	public void updateDateTimeIssued(String dateTimeIssued)
	{
		header().setDateTimeIssued(dateTimeIssued);
	}

	@Override
	public String fetchDateTimeIssued()
	{
		return header().getDateTimeIssued();
	}

	@Override
	public void updateInternalCode(String internalCode)
	{
		header().setReceiptNumber(internalCode);
	}

	@Override
	public void updateIssuer(TaxAuthorityEntityWithAddress issuer)
	{
		seller().setRin(issuer.getId());
		seller().setCompanyTradeName(issuer.getName());
		TaxAuthorityAddress address = issuer.address();
		seller().setBranchCode(address.fetchBranchId());
		address.updateBranchId(null);
		seller().setBranchAddress(address);
	}

	@Override
	public TaxAuthorityIssuer fetchIssuer()
	{
		TaxAuthorityIssuer issuer = new TaxAuthorityIssuer();
		issuer.setId(seller().getRin());
		issuer.setName(seller().getCompanyTradeName());
		TaxAuthorityIssuerAddress issuerAddress = new TaxAuthorityIssuerAddress();
		issuerAddress.copyFrom(seller().getBranchAddress());
		issuerAddress.setBranchId(seller().getBranchCode());
		issuer.setAddress(issuerAddress);
		return issuer;
	}

	@Override
	public void updateDelivery(TaxAuthorityDelivery delivery)
	{
	}

	@Override
	public TaxAuthorityDelivery fetchDelivery()
	{
		return null;
	}

	@Override
	public void updateReceiver(TaxAuthorityReceiver receiver)
	{
		buyer().setType(receiver.getType());
		buyer().setId(receiver.getId());
		String name = receiver.getName();
		if (ObjectChecker.isNotEmptyOrNull(receiver.getAddress().getAdditionalInformation()))
			name = name.concat("  ").concat(receiver.getAddress().getAdditionalInformation());
		buyer().setName(name);
	}

	@Override
	public TaxAuthorityReceiver fetchReceiver()
	{
		TaxAuthorityReceiver receiver = new TaxAuthorityReceiver();
		receiver.setType(buyer().getType());
		receiver.setId(buyer().getId());
		receiver.setName(buyer().getName());
		return receiver;
	}

	@Override
	public void updatePayment(TaxAuthorityPayment payment)
	{

	}

	@Override
	public TaxAuthorityPayment fetchPayment()
	{
		return null;
	}

	@Override
	public void updateTotalSalesAmount(BigDecimal totalSalesAmount)
	{
		setTotalSales(totalSalesAmount);
	}

	@Override
	public void updateTotalDiscountAmount(BigDecimal totalDiscountAmount)
	{
		setTotalCommercialDiscount(totalDiscountAmount);
	}

	@Override
	public BigDecimal fetchTotalDiscountAmount()
	{
		return getTotalCommercialDiscount();
	}

	@Override
	public void updateNetAmount(BigDecimal netAmount)
	{
		setNetAmount(netAmount);
	}

	@Override
	public void updateExtraDiscountAmount(BigDecimal extraDiscountAmount)
	{
	}

	@Override
	public void updateTotalItemsDiscountAmount(BigDecimal totalItemsDiscountAmount)
	{
		setTotalItemsDiscount(totalItemsDiscountAmount);
	}

	@Override
	public BigDecimal fetchTotalItemsDiscountAmount()
	{
		return getTotalItemsDiscount();
	}

	public List<EReceiptLine> lines()
	{
		if (getItemData() == null)
			setItemData(new ArrayList<>());
		return getItemData();
	}

	@Override
	public <T extends EInvoiceDocLine> void addLine(T line)
	{
		lines().add((EReceiptLine) line);
	}

	@XmlTransient
	public List<TaxAuthoritySignature> getSignatures()
	{
		return signatures;
	}

	public void setSignatures(List<TaxAuthoritySignature> signatures)
	{
		this.signatures = signatures;
	}

	@Override
	public void updateLines(List<? extends EInvoiceDocLine> lines)
	{
		setItemData(CollectionsUtility.castList(lines));
	}

	@Override
	public List<EInvoiceDocLine> fetchLines()
	{
		return CollectionsUtility.castList(lines());
	}

	@Override
	public String cancelledDocumentUUID()
	{
		return header().getUuid();
	}

	@Override
	public boolean eInvoiceSubmission()
	{
		return false;
	}

	@Override
	public String fetchInternalCode()
	{
		return header().getReceiptNumber();
	}

	@Override
	public BigDecimal fetchTotalSalesAmount()
	{
		return getTotalSales();
	}

	@Override
	public BigDecimal fetchNetAmount()
	{
		return getNetAmount();
	}

	@Override
	public void updateHeaderCurrency(String currency)
	{
		header().setCurrency(currency);
	}

	@Override
	public void updateHeaderCurrencyRate(BigDecimal rate)
	{
		header().setExchangeRate(rate);
	}

	@Override
	public String fetchHeaderCurrency()
	{
		return header().getCurrency();
	}

	@Override
	public BigDecimal fetchHeaderCurrencyRate()
	{
		return header().getExchangeRate();
	}

	@Override
	public void updateGeneratedUUID(String uuid)
	{
		header().setUuid(uuid);
	}

	@Override
	public void updateOldUUID(String uuid)
	{
		header().setReferenceOldUUID(uuid);
	}

	@Override
	public void updatePreviousUUID(String uuid)
	{
		header().setPreviousUUID(uuid);
	}

	@Override
	public void updatePaymentMethod(String paymentMethodCode)
	{
		setPaymentMethod(paymentMethodCode);
	}

	@Override
	public String fetchUUID()
	{
		return header().getUuid();
	}

	@Override
	public boolean documentVersionRequireSignature()
	{
		return true;
	}

	@Override
	public boolean shouldValidateSignature()
	{
		return false;
	}

	@Override
	public boolean shouldCheckReceiverAddress()
	{
		return false;
	}

	@Override
	public <T extends EInvoiceDocLine> T  createLine()
	{
		return (T) new EReceiptLine();
	}

	@Override
	public BigDecimal fetchFinalTotalAmount()
	{
		return getTotalAmount();
	}

	@Override
	public void updateFinalTotalAmount(BigDecimal totalAmount)
	{
		setTotalAmount(totalAmount);
	}
}
