package com.namasoft.taxauthority.jordan;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.taxauthority.ksa.entities.UBLEInvoiceTypeCode;

import jakarta.xml.bind.annotation.*;

@XmlRootElement(name = "Invoice")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class JoFotaraInvoiceReturn extends AbsJoFotaraInvoice
{
	public JoFotaraInvoiceReturn()
	{
		setInvoiceTypeCode(UBLEInvoiceTypeCode.CREDIT_NOTE.getCode());
	}

	@Override
	public String edocumentType()
	{
		if (ObjectChecker.areEqual(JoFotaraInvoiceType.Income, getJoFotaraInvoiceType()))
			return "IncomeInvoiceReturn";
		if (ObjectChecker.areEqual(JoFotaraInvoiceType.Public, getJoFotaraInvoiceType()))
			return "PublicInvoiceReturn";
		return "PrivateInvoiceReturn";
	}

	@Override
	public boolean ifReturn()
	{
		return true;
	}
}
