package com.namasoft.taxauthority.ksa.entities;

import com.namasoft.common.utilities.*;
import com.namasoft.taxauthority.*;

import java.math.BigDecimal;
import java.util.*;

public class ZATCAEInvoiceLine extends EInvoiceDocLine
{
	private int index = -1;
	private String unitCode;
	private String itemAllowanceReason;
	private String itemAllowanceReasonCode;
	private String itemName;
	private BigDecimal quantity;
	private BigDecimal itemNetAmount;
	private Boolean chargeApplied = false;
	private BigDecimal itemAllowancePercent;
	private BigDecimal itemAllowanceAmount;
	private BigDecimal itemTotalAmount;
	private BigDecimal itemTaxAmount;
	private BigDecimal itemFinalAmount;
	private BigDecimal unitPrice;
	private List<ZATCATaxLine> taxes;

	public int getIndex()
	{
		return index;
	}

	public void setIndex(int index)
	{
		this.index = index;
	}

	public String getUnitCode()
	{
		return unitCode;
	}

	public void setUnitCode(String unitCode)
	{
		this.unitCode = unitCode;
	}

	public BigDecimal getQuantity()
	{
		return quantity;
	}

	public void setQuantity(BigDecimal quantity)
	{
		this.quantity = quantity;
	}

	public String getItemAllowanceReason()
	{
		return itemAllowanceReason;
	}

	public void setItemAllowanceReason(String itemAllowanceReason)
	{
		this.itemAllowanceReason = itemAllowanceReason;
	}

	public String getItemAllowanceReasonCode()
	{
		return itemAllowanceReasonCode;
	}

	public void setItemAllowanceReasonCode(String itemAllowanceReasonCode)
	{
		this.itemAllowanceReasonCode = itemAllowanceReasonCode;
	}

	public String getItemName()
	{
		return itemName;
	}

	public void setItemName(String itemName)
	{
		this.itemName = itemName;
	}

	public List<ZATCATaxLine> getTaxes()
	{
		if (taxes == null)
			taxes = new ArrayList<>();
		return taxes;
	}

	public void setTaxes(List<ZATCATaxLine> taxes)
	{
		this.taxes = taxes;
	}

	public BigDecimal getItemNetAmount()
	{
		return itemNetAmount;
	}

	public void setItemNetAmount(BigDecimal itemNetAmount)
	{
		this.itemNetAmount = itemNetAmount;
	}

	public Boolean getChargeApplied()
	{
		return chargeApplied;
	}

	public void setChargeApplied(Boolean chargeApplied)
	{
		this.chargeApplied = chargeApplied;
	}

	public BigDecimal getItemAllowancePercent()
	{
		return itemAllowancePercent;
	}

	public void setItemAllowancePercent(BigDecimal itemAllowancePercent)
	{
		this.itemAllowancePercent = itemAllowancePercent;
	}

	public BigDecimal getItemAllowanceAmount()
	{
		return itemAllowanceAmount;
	}

	public void setItemAllowanceAmount(BigDecimal itemAllowanceAmount)
	{
		this.itemAllowanceAmount = itemAllowanceAmount;
	}

	public BigDecimal getItemTotalAmount()
	{
		return itemTotalAmount;
	}

	public void setItemTotalAmount(BigDecimal itemTotalAmount)
	{
		this.itemTotalAmount = itemTotalAmount;
	}

	public BigDecimal getItemTaxAmount()
	{
		return itemTaxAmount;
	}

	public void setItemTaxAmount(BigDecimal itemTaxAmount)
	{
		this.itemTaxAmount = itemTaxAmount;
	}

	public BigDecimal getItemFinalAmount()
	{
		return itemFinalAmount;
	}

	public void setItemFinalAmount(BigDecimal itemFinalAmount)
	{
		this.itemFinalAmount = itemFinalAmount;
	}

	public BigDecimal getUnitPrice()
	{
		return unitPrice;
	}

	public void setUnitPrice(BigDecimal unitPrice)
	{
		this.unitPrice = unitPrice;
	}

	public BigDecimal allowanceAmount()
	{
		BigDecimal amount = NaMaMath.zeroIfNull(itemAllowanceAmount);
		return chargeApplied ? BigDecimal.ZERO : amount;
	}

	public BigDecimal chargeAmount()
	{
		BigDecimal amount = NaMaMath.zeroIfNull(itemAllowanceAmount);
		return chargeApplied ? amount : BigDecimal.ZERO;
	}

	public void roundAmounts(int scale)
	{
		setItemNetAmount(NaMaMath.round(getItemNetAmount(), scale).stripTrailingZeros());
		setItemAllowanceAmount(NaMaMath.round(getItemAllowanceAmount(), scale).stripTrailingZeros());
		setItemTotalAmount(NaMaMath.round(getItemTotalAmount(), scale).stripTrailingZeros());
		setItemTaxAmount(NaMaMath.round(getItemTaxAmount(), scale).stripTrailingZeros());
		setItemFinalAmount(NaMaMath.round(getItemFinalAmount(), scale).stripTrailingZeros());
	}

	@Override
	public void updateUnitPrice(TaxAuthorityUnitValue unitValue)
	{
		setUnitPrice(ObjectChecker.getFirstNotNullObj(unitValue.getAmountSold() , unitValue.getAmountEGP()));
	}

	@Override
	public void calcSalesTotal()
	{
		setItemTotalAmount(getQuantity().multiply(getUnitPrice()));
	}

	@Override
	public void updateSalesTotal(BigDecimal salesTotal)
	{
		setItemTotalAmount(salesTotal);
	}

	@Override
	public BigDecimal fetchSalesTotal()
	{
		return getItemTotalAmount();
	}

	@Override
	public void calcNetTotal()
	{
		BigDecimal allowanceAmount = NaMaMath.zeroIfNull(getItemAllowanceAmount());
		setItemNetAmount(getItemTotalAmount().subtract(getChargeApplied() ? allowanceAmount.negate() : allowanceAmount));
	}

	@Override
	public void updateNetTotal(BigDecimal netTotal)
	{
		setItemNetAmount(netTotal);
	}

	@Override
	public BigDecimal fetchNetTotal()
	{
		return getItemNetAmount();
	}

	@Override
	public void calcTotal()
	{
		setItemFinalAmount(getItemNetAmount().add(NaMaMath.zeroIfNull(getItemTaxAmount())));
	}

	@Override
	public void updateTotal(BigDecimal total)
	{
		setItemFinalAmount(total);
	}

	@Override
	public BigDecimal fetchFinalTotal()
	{
		return getItemFinalAmount();
	}

	@Override
	public void updateUnitType(String unitType)
	{
		setUnitCode(unitType);
	}

	@Override
	public void updateDiscount(TaxAuthorityDiscount discount)
	{
		if (ObjectChecker.isEmptyOrNull(discount))
			return;
		if (ObjectChecker.isEmptyOrZero(discount.getAmount()))
			return;
		setItemAllowanceReason("Discount");
		setItemAllowanceReasonCode("2");
		setItemAllowancePercent(discount.getRate());
		setItemAllowanceAmount(discount.getAmount());
		setChargeApplied(false);
	}

	@Override
	public TaxAuthorityDiscount fetchDiscount()
	{
		TaxAuthorityDiscount discount = new TaxAuthorityDiscount();
		discount.updateNulls();
		if (ObjectChecker.isFalse(getChargeApplied()))
		{
			discount.setRate(getItemAllowancePercent());
			discount.setAmount(getItemAllowanceAmount());
		}
		return discount;
	}

	@Override
	public void updateTaxableItems(List<TaxAuthorityLineTax> taxableItems)
	{
		if (taxableItems == null)
			return;
		getTaxes().clear();
		BigDecimal taxAmount = BigDecimal.ZERO;
		for (TaxAuthorityLineTax tax : taxableItems)
		{
			ZATCATaxLine line = new ZATCATaxLine();
			getTaxes().add(line);
			line.setTaxPercent(tax.getRate());
			line.setTaxAmount(tax.getAmount());
			taxAmount = taxAmount.add(line.getTaxAmount());
			line.setTaxCategory(tax.getSubType());
			line.setTaxType(tax.getTaxType());
			line.setTaxableAmount(getItemNetAmount());
			if (ObjectChecker.areEqual(line.getTaxCategory(), "E"))
			{
				line.setExempted(true);
				line.setTaxExemptionReason("Exempted Item");
			}
		}
		setItemTaxAmount(taxAmount);
	}

	@Override
	public List<TaxAuthorityLineTax> fetchTaxableItems()
	{
		List<TaxAuthorityLineTax> taxes = new ArrayList<>();
		for (ZATCATaxLine line : getTaxes())
		{
			TaxAuthorityLineTax tax = new TaxAuthorityLineTax();
			taxes.add(tax);
			tax.setSubType(line.getTaxCategory());
			tax.setTaxType(line.getTaxType());
			tax.setAmount(line.getTaxAmount());
			tax.setRate(line.getTaxPercent());
		}
		return taxes;
	}

	@Override
	public void updateTotalTaxableFees(BigDecimal totalTaxableFees)
	{

	}

	@Override
	public void updateItemsDiscount(BigDecimal itemsDiscount)
	{

	}

	@Override
	public void updateItemCode(String itemCode)
	{
		setItemName(itemCode);
	}

	@Override
	public String fetchItemCode()
	{
		return getItemName();
	}

	@Override
	public void updateItemType(String itemType)
	{

	}

	@Override
	public void updateInternalCode(String internalCode)
	{

	}

	@Override
	public void updateDescription(String description)
	{

	}

	@Override
	public BigDecimal fetchItemsDiscount()
	{
		return BigDecimal.ZERO;
	}

	@Override
	public String fetchUnitType()
	{
		return getUnitCode();
	}

	@Override
	public String currencySold(EInvoiceDoc doc)
	{
		return doc.fetchHeaderCurrency();
	}

	@Override
	public BigDecimal currencyRate(EInvoiceDoc doc)
	{
		return doc.fetchHeaderCurrencyRate();
	}

	@Override
	public String fetchItemType()
	{
		return null;
	}

	@Override
	public String fetchDescription()
	{
		return null;
	}

	@Override
	public String fetchInternalCode()
	{
		return null;
	}

	@Override
	public BigDecimal fetchUnitPrice()
	{
		return getUnitPrice();
	}

	public BigDecimal quantity()
	{
		return NaMaMath.zeroIfNull(quantity);
	}

	public BigDecimal itemNetAmount()
	{
		return NaMaMath.zeroIfNull(itemNetAmount);
	}

	public BigDecimal itemAllowancePercent()
	{
		return NaMaMath.zeroIfNull(itemAllowancePercent);
	}

	public BigDecimal itemAllowanceAmount()
	{
		return NaMaMath.zeroIfNull(itemAllowanceAmount);
	}

	public BigDecimal itemTotalAmount()
	{
		return NaMaMath.zeroIfNull(itemTotalAmount);
	}

	public BigDecimal itemTaxAmount()
	{
		return NaMaMath.zeroIfNull(itemTaxAmount);
	}

	public BigDecimal itemFinalAmount()
	{
		return NaMaMath.zeroIfNull(itemFinalAmount);
	}

	public BigDecimal unitPrice()
	{
		return NaMaMath.zeroIfNull(unitPrice);
	}

	@Override
	public void updateLineIndex(int index)
	{
		setIndex(index);
	}
}
