package com.namasoft.contracts.common;

import com.namasoft.common.*;
import com.namasoft.common.constants.CommonConstants;
import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.common.objects.DTOFileAttachmentInfo;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import com.namasoft.specialserialization.FlatObjectUtilies;
import com.namasoft.common.utils.ReplicationSiteSettings;

import jakarta.activation.*;
import java.io.File;

public class DTOLargeDataUtil
{
	public static FlatObject createForRecordImport(Pair<File, String> file)
	{
		DTOLargeData largeData = new DTOLargeData();
		DTOFileAttachmentInfo attachmentInfo = new DTOFileAttachmentInfo();
		attachmentInfo.setFileName(file.getY());
		attachmentInfo.setUpdated(true);
		attachmentInfo.setFileId(SequentialUUID.geenerateStrUUID(ReplicationSiteSettings.getSiteSequence(), CommonConstants.GUI_MODULE_ID));
		largeData.setAttachmentInfo(attachmentInfo);
		largeData.setDataLength(file.getX().length());
		largeData.setData(new DataHandler(new FileDataSource(file.getX())));
		FlatObject flatObject = FlatObjectUtilies.createFlatObject(largeData);
		flatObject.setFieldValue("data", largeData.getData());
		return flatObject;
	}

}
