package com.namasoft.contracts.common.dtos;

import com.namasoft.common.*;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.*;
import com.namasoft.infra.contractsbase.common.approval.DTOApprovalCase;
import jakarta.xml.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class BaseEntityDTO extends NaMaDTO implements Serializable, IBaseEntityDTO, HasDTODimensionsRef
{
	private String barcode;
	private String invalidBarcodes;
	private EntityReferenceData legalEntity;
	private EntityReferenceData analysisSet;
	private EntityReferenceData department;
	private EntityReferenceData branch;
	private EntityReferenceData sector;
	private String id = "";
	private String entityType = "";
	protected String code = "";
	protected String colorCode = "";
	protected String actualCode = "";
	private Date creationDate;
	private boolean commitedBefore = false;
	private boolean draftCreated = false;
	private EntityReferenceData editedBy;
	private DTOApprovalCase currentApprovalCase;
	private String generationType;
	private Integer lastChangeVersion;
	private Integer currentVersion;
	private EntityReferenceData updateCapability;
	private EntityReferenceData viewCapability;
	private EntityReferenceData usageCapability;
	private Date lastUpdateDate;
	private EntityReferenceData firstAuthor;
	private Boolean revised;
	private Boolean preventUsage;
	private String reviseLevel;
	private String description1;
	private String description2;
	private String description3;
	private String description4;
	private String description5;
	private BigDecimal n1;
	private BigDecimal n2;
	private BigDecimal n3;
	private BigDecimal n4;
	private BigDecimal n5;
	private Date date1;
	private Date date2;
	private Date date3;
	private Date date4;
	private Date date5;
	private EntityReferenceData ref1;
	private EntityReferenceData ref2;
	private EntityReferenceData ref3;
	private EntityReferenceData ref4;
	private EntityReferenceData ref5;
	private Integer printCount;
	private String sqlField1;
	private String sqlField2;
	private String sqlField3;
	private String sqlField4;
	private String sqlField5;
	private String sqlField6;
	private String sqlField7;
	private String sqlField8;
	private String sqlField9;
	private String sqlField10;
	private String sqlField11;
	private String sqlField12;
	private String sqlField13;
	private String sqlField14;
	private String sqlField15;
	private String sqlField16;
	private String sqlField17;
	private String sqlField18;
	private String sqlField19;
	private String sqlField20;
	private EntityReferenceData generatedFrom;
	private String generatedByLine;
	private String arabicTitle;
	private String englishTitle;
	private EntityReferenceData docCategory;
	private String customViewName;
	private String remarks;
	private String documentFileStatus;
	private String fromMobileDeviceId;
	private Boolean checkMobileIdentifierBeforeSave;
	private List<String> mobileTitles;
	private List<DTOConfirmation> confirmations;
	private Boolean purged;
	@GwtTransient
	private Map<String, Object> prevalidationResult;
	private Boolean vueReadOnly;
	private String duplicatedFrom = null;

	public void setDuplicatedFrom(String duplicatedFrom)
	{
		this.duplicatedFrom = duplicatedFrom;
	}

	public String getDuplicatedFrom()
	{
		return duplicatedFrom;
	}

	public EntityReferenceData getDocCategory()
	{
		return docCategory;
	}

	public void setDocCategory(EntityReferenceData docCategory)
	{
		this.docCategory = docCategory;
	}

	public String getSqlField11()
	{
		return sqlField11;
	}

	public void setSqlField11(String sqlField11)
	{
		this.sqlField11 = sqlField11;
	}

	public String getSqlField12()
	{
		return sqlField12;
	}

	public void setSqlField12(String sqlField12)
	{
		this.sqlField12 = sqlField12;
	}

	public String getSqlField13()
	{
		return sqlField13;
	}

	public void setSqlField13(String sqlField13)
	{
		this.sqlField13 = sqlField13;
	}

	public String getSqlField14()
	{
		return sqlField14;
	}

	public void setSqlField14(String sqlField14)
	{
		this.sqlField14 = sqlField14;
	}

	public String getSqlField15()
	{
		return sqlField15;
	}

	public void setSqlField15(String sqlField15)
	{
		this.sqlField15 = sqlField15;
	}

	public String getSqlField16()
	{
		return sqlField16;
	}

	public void setSqlField16(String sqlField16)
	{
		this.sqlField16 = sqlField16;
	}

	public String getSqlField17()
	{
		return sqlField17;
	}

	public void setSqlField17(String sqlField17)
	{
		this.sqlField17 = sqlField17;
	}

	public String getSqlField18()
	{
		return sqlField18;
	}

	public void setSqlField18(String sqlField18)
	{
		this.sqlField18 = sqlField18;
	}

	public String getSqlField19()
	{
		return sqlField19;
	}

	public void setSqlField19(String sqlField19)
	{
		this.sqlField19 = sqlField19;
	}

	public String getSqlField20()
	{
		return sqlField20;
	}

	public void setSqlField20(String sqlField20)
	{
		this.sqlField20 = sqlField20;
	}

	public String getSqlField6()
	{
		return sqlField6;
	}

	public void setSqlField6(String sqlField6)
	{
		this.sqlField6 = sqlField6;
	}

	public String getSqlField7()
	{
		return sqlField7;
	}

	public void setSqlField7(String sqlField7)
	{
		this.sqlField7 = sqlField7;
	}

	public String getSqlField8()
	{
		return sqlField8;
	}

	public void setSqlField8(String sqlField8)
	{
		this.sqlField8 = sqlField8;
	}

	public String getSqlField9()
	{
		return sqlField9;
	}

	public void setSqlField9(String sqlField9)
	{
		this.sqlField9 = sqlField9;
	}

	public String getSqlField10()
	{
		return sqlField10;
	}

	public void setSqlField10(String sqlField10)
	{
		this.sqlField10 = sqlField10;
	}

	public String getSqlField1()
	{
		return sqlField1;
	}

	public void setSqlField1(String sqlField1)
	{
		this.sqlField1 = sqlField1;
	}

	public String getSqlField2()
	{
		return sqlField2;
	}

	public void setSqlField2(String sqlField2)
	{
		this.sqlField2 = sqlField2;
	}

	public String getSqlField3()
	{
		return sqlField3;
	}

	public void setSqlField3(String sqlField3)
	{
		this.sqlField3 = sqlField3;
	}

	public String getSqlField4()
	{
		return sqlField4;
	}

	public void setSqlField4(String sqlField4)
	{
		this.sqlField4 = sqlField4;
	}

	public String getSqlField5()
	{
		return sqlField5;
	}

	public void setSqlField5(String sqlField5)
	{
		this.sqlField5 = sqlField5;
	}

	protected BaseEntityDTO()
	{
		super();
	}

	protected BaseEntityDTO(String type)
	{
		this();
		entityType = type;
	}

	// public List<BinaryFile> getAttachments()
	// {
	// return attachments;
	// }
	//
	// public void setAttachments(List<BinaryFile> attachments)
	// {
	// this.attachments = attachments;
	// }
	//

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	@Override
	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public String getCode()
	{
		return code;
	}

	public String getActualCode()
	{
		return actualCode;
	}

	public void setActualCode(String actualCode)
	{
		this.actualCode = actualCode;
	}

	public void setCode(String code)
	{
		this.code = code;
	}

	@Override
	public Date getCreationDate()
	{
		return creationDate;
	}

	public void setCreationDate(Date creationDate)
	{
		this.creationDate = creationDate;
	}

	public boolean isCommitedBefore()
	{
		return commitedBefore;
	}

	public void setCommitedBefore(boolean commitedBefore)
	{
		this.commitedBefore = commitedBefore;
	}

	public boolean isDraftCreated()
	{
		return draftCreated;
	}

	public void setDraftCreated(boolean draftCreated)
	{
		this.draftCreated = draftCreated;
	}

	public EntityReferenceData getEditedBy()
	{
		return editedBy;
	}

	public void setEditedBy(EntityReferenceData editedBy)
	{
		this.editedBy = editedBy;
	}

	public DTOApprovalCase getCurrentApprovalCase()
	{
		return currentApprovalCase;
	}

	public void setCurrentApprovalCase(DTOApprovalCase currentApprovalCase)
	{
		this.currentApprovalCase = currentApprovalCase;
	}

	public EntityReferenceData getAnalysisSet()
	{
		return analysisSet;
	}

	public void setAnalysisSet(EntityReferenceData analysisSet)
	{
		this.analysisSet = analysisSet;
	}

	public EntityReferenceData getDepartment()
	{
		return department;
	}

	public void setDepartment(EntityReferenceData department)
	{
		this.department = department;
	}

	public EntityReferenceData getBranch()
	{
		return branch;
	}

	public void setBranch(EntityReferenceData branch)
	{
		this.branch = branch;
	}

	public EntityReferenceData getSector()
	{
		return sector;
	}

	public void setSector(EntityReferenceData sector)
	{
		this.sector = sector;
	}

	@Override
	public String getGenerationType()
	{
		return generationType;
	}

	public void setGenerationType(String generationType)
	{
		this.generationType = generationType;
	}

	public Integer getLastChangeVersion()
	{
		return lastChangeVersion;
	}

	public void setLastChangeVersion(Integer lastChangeVersion)
	{
		this.lastChangeVersion = lastChangeVersion;
	}

	public Integer getCurrentVersion()
	{
		return currentVersion;
	}

	public void setCurrentVersion(Integer currentVersion)
	{
		this.currentVersion = currentVersion;
	}

	public EntityReferenceData getUpdateCapability()
	{
		return updateCapability;
	}

	public void setUpdateCapability(EntityReferenceData updateCapability)
	{
		this.updateCapability = updateCapability;
	}

	public EntityReferenceData getViewCapability()
	{
		return viewCapability;
	}

	public void setViewCapability(EntityReferenceData viewCapability)
	{
		this.viewCapability = viewCapability;
	}

	public EntityReferenceData getUsageCapability()
	{
		return usageCapability;
	}

	public void setUsageCapability(EntityReferenceData usageCapability)
	{
		this.usageCapability = usageCapability;
	}

	@Override
	public Date getLastUpdateDate()
	{
		return lastUpdateDate;
	}

	public void setLastUpdateDate(Date lastUpdateDate)
	{
		this.lastUpdateDate = lastUpdateDate;
	}

	public EntityReferenceData getFirstAuthor()
	{
		return firstAuthor;
	}

	public void setFirstAuthor(EntityReferenceData firstAuthor)
	{
		this.firstAuthor = firstAuthor;
	}

	public Boolean getRevised()
	{
		return revised;
	}

	public void setRevised(Boolean revised)
	{
		this.revised = revised;
	}

	public String getReviseLevel()
	{
		return reviseLevel;
	}

	public void setReviseLevel(String reviseLevel)
	{
		this.reviseLevel = reviseLevel;
	}

	public String getDescription1()
	{
		return description1;
	}

	public void setDescription1(String description1)
	{
		this.description1 = description1;
	}

	public String getDescription2()
	{
		return description2;
	}

	public void setDescription2(String description2)
	{
		this.description2 = description2;
	}

	public String getDescription3()
	{
		return description3;
	}

	public void setDescription3(String description3)
	{
		this.description3 = description3;
	}

	public String getDescription4()
	{
		return description4;
	}

	public void setDescription4(String description4)
	{
		this.description4 = description4;
	}

	public String getDescription5()
	{
		return description5;
	}

	public void setDescription5(String description5)
	{
		this.description5 = description5;
	}

	public BigDecimal getN1()
	{
		return n1;
	}

	public void setN1(BigDecimal n1)
	{
		this.n1 = n1;
	}

	public BigDecimal getN2()
	{
		return n2;
	}

	public void setN2(BigDecimal n2)
	{
		this.n2 = n2;
	}

	public BigDecimal getN3()
	{
		return n3;
	}

	public void setN3(BigDecimal n3)
	{
		this.n3 = n3;
	}

	public BigDecimal getN4()
	{
		return n4;
	}

	public void setN4(BigDecimal n4)
	{
		this.n4 = n4;
	}

	public BigDecimal getN5()
	{
		return n5;
	}

	public void setN5(BigDecimal n5)
	{
		this.n5 = n5;
	}

	public Date getDate1()
	{
		return date1;
	}

	public void setDate1(Date date1)
	{
		this.date1 = date1;
	}

	public Date getDate2()
	{
		return date2;
	}

	public void setDate2(Date date2)
	{
		this.date2 = date2;
	}

	public Date getDate3()
	{
		return date3;
	}

	public void setDate3(Date date3)
	{
		this.date3 = date3;
	}

	public Date getDate4()
	{
		return date4;
	}

	public void setDate4(Date date4)
	{
		this.date4 = date4;
	}

	public Date getDate5()
	{
		return date5;
	}

	public void setDate5(Date date5)
	{
		this.date5 = date5;
	}

	public EntityReferenceData getRef1()
	{
		return ref1;
	}

	public void setRef1(EntityReferenceData ref1)
	{
		this.ref1 = ref1;
	}

	public EntityReferenceData getRef2()
	{
		return ref2;
	}

	public void setRef2(EntityReferenceData ref2)
	{
		this.ref2 = ref2;
	}

	public EntityReferenceData getRef3()
	{
		return ref3;
	}

	public void setRef3(EntityReferenceData ref3)
	{
		this.ref3 = ref3;
	}

	public EntityReferenceData getRef4()
	{
		return ref4;
	}

	public void setRef4(EntityReferenceData ref4)
	{
		this.ref4 = ref4;
	}

	public EntityReferenceData getRef5()
	{
		return ref5;
	}

	public void setRef5(EntityReferenceData ref5)
	{
		this.ref5 = ref5;
	}

	public Integer getPrintCount()
	{
		return printCount;
	}

	public void setPrintCount(Integer printCount)
	{
		this.printCount = printCount;
	}

	public EntityReferenceData getGeneratedFrom()
	{
		return generatedFrom;
	}

	public void setGeneratedFrom(EntityReferenceData generatedFrom)
	{
		this.generatedFrom = generatedFrom;
	}

	public String getGeneratedByLine()
	{
		return generatedByLine;
	}

	public void setGeneratedByLine(String generatedByLine)
	{
		this.generatedByLine = generatedByLine;
	}

	public String getArabicTitle()
	{
		return arabicTitle;
	}

	public void setArabicTitle(String arabicTitle)
	{
		this.arabicTitle = arabicTitle;
	}

	public String getEnglishTitle()
	{
		return englishTitle;
	}

	public void setEnglishTitle(String englishTitle)
	{
		this.englishTitle = englishTitle;
	}

	public String getColorCode()
	{
		return colorCode;
	}

	public void setColorCode(String colorCode)
	{
		this.colorCode = colorCode;
	}

	public Boolean getPreventUsage()
	{
		return preventUsage;
	}

	public void setPreventUsage(Boolean preventUsage)
	{
		this.preventUsage = preventUsage;
	}

	public String getCustomViewName()
	{
		return customViewName;
	}

	public void setCustomViewName(String customViewName)
	{
		this.customViewName = customViewName;
	}

	public String calcEntityType()
	{
		return getClass().getSimpleName().substring(3);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj instanceof BaseEntityDTO)
			return ObjectChecker.areEqual(getId(), ((BaseEntityDTO) obj).getId());
		return super.equals(obj);
	}

	@Override
	public int hashCode()
	{
		return ObjectChecker.toStringOrEmpty(getId()).hashCode();
	}

	public boolean isInAprrovalCycle()
	{
		DTOApprovalCase lastApprovalCase = getCurrentApprovalCase();
		if (lastApprovalCase == null)
			return false;
		return ObjectChecker.areEqual(lastApprovalCase.getState(), "InProgress");
	}

	public String getRemarks()
	{
		return remarks;
	}

	public void setRemarks(String remark)
	{
		this.remarks = remark;
	}

	public String getDocumentFileStatus()
	{
		return documentFileStatus;
	}

	public void setDocumentFileStatus(String documentFileStatus)
	{
		this.documentFileStatus = documentFileStatus;
	}

	public String getFromMobileDeviceId()
	{
		return fromMobileDeviceId;
	}

	public void setFromMobileDeviceId(String fromMobileDeviceId)
	{
		this.fromMobileDeviceId = fromMobileDeviceId;
	}

	public Boolean getCheckMobileIdentifierBeforeSave()
	{
		return checkMobileIdentifierBeforeSave;
	}

	public void setCheckMobileIdentifierBeforeSave(Boolean checkMobileIdentifierBeforeSave)
	{
		this.checkMobileIdentifierBeforeSave = checkMobileIdentifierBeforeSave;
	}

	public Boolean getPurged()
	{
		return purged;
	}

	public void setPurged(Boolean purged)
	{
		this.purged = purged;
	}

	private List<String> posAliases;

	public void setPosAliases(List<String> aliases)
	{
		this.posAliases = aliases;
	}

	public List<String> getPosAliases()
	{
		return posAliases;
	}

	public List<String> getMobileTitles()
	{
		return mobileTitles;
	}

	public void setMobileTitles(List<String> mobileTitles)
	{
		this.mobileTitles = mobileTitles;
	}

	public List<DTOConfirmation> getConfirmations()
	{
		return confirmations;
	}

	public void setConfirmations(List<DTOConfirmation> confirmations)
	{
		this.confirmations = confirmations;
	}

	public Map<String, Object> getPrevalidationResult()
	{
		return prevalidationResult;
	}

	public void setPrevalidationResult(Map<String, Object> prevalidationResult)
	{
		this.prevalidationResult = prevalidationResult;
	}

	public Boolean getVueReadOnly()
	{
		return vueReadOnly;
	}

	public void setVueReadOnly(Boolean vueReadOnly)
	{
		this.vueReadOnly = vueReadOnly;
	}

	public String getBarcode()
	{
		return barcode;
	}

	public void setBarcode(String barcode)
	{
		this.barcode = barcode;
	}

	public String getInvalidBarcodes()
	{
		return invalidBarcodes;
	}

	public void setInvalidBarcodes(String invalidBarcodes)
	{
		this.invalidBarcodes = invalidBarcodes;
	}
}