package com.namasoft.contracts.common.dtos;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.entities.*;

import jakarta.xml.bind.annotation.*;
import java.io.Serializable;
import java.util.List;

@XmlRootElement
public class CurrentLoginInfo implements Serializable
{
	private boolean loggedIn;
	private EntityReferenceData timedQuery;
	private Long timedQueryDelayInSeconds;
	private Integer autoLogoutTime;
	private DTOUser userInfo;
	private DTOMenuDefinition menu;
	private String pHash;
	private String deviceId;
	private SettingsDTO defaultSettings;
	private Long lastNotification = (long) 0;
	private EntityDimensionsDTO dimensions;
	private String customDimensionsDescriptionAr;
	private String customDimensionsDescriptionEn;
	private Language preferedLanguage;
	private List<String> allowedEntities;
	private List<String> allowedFeatures;
	private List<String> userPreventedEntities;
	private List<String> userPreventedFeatures;
	private DTOShortCutsDefinition shortCuts;
	private List<String> definedGUIActions;
	private Boolean barCodeOn;
	private Boolean hijriDate;
	private Boolean alwaysPrint1InBarcode;
	private Boolean directPrint;
	private Boolean autoLogoutRememberMe;
	private DTOUserFavourites favourites;
	private Boolean mobileVerificationCodeOn;
	private String otpId;

	public boolean isLoggedIn()
	{
		return loggedIn;
	}

	public void setLoggedIn(boolean loggedIn)
	{
		this.loggedIn = loggedIn;
	}

	public String getpHash()
	{
		return pHash;
	}

	public void setpHash(String pHash)
	{
		this.pHash = pHash;
	}

	public DTOUser getUserInfo()
	{
		return userInfo;
	}

	public void setUserInfo(DTOUser userInfo)
	{
		this.userInfo = userInfo;
	}

	public DTOMenuDefinition getMenu()
	{
		return menu;
	}

	public void setMenu(DTOMenuDefinition menu)
	{
		this.menu = menu;
	}

	public CurrentLoginInfo()
	{
	}

	public static CurrentLoginInfo loggedIn(LoginResult loginInfo, String pHash, SettingsDTO defaultSettings, String deviceId,
			List<String> guiActions, Integer autoLogoutTime, Boolean autoLogoutRememberMe)
	{
		CurrentLoginInfo currentLoginInfo = new CurrentLoginInfo();
		currentLoginInfo.setFavourites(loginInfo.getFavourites());
		currentLoginInfo.setAutoLogoutRememberMe(autoLogoutRememberMe);
		currentLoginInfo.setAutoLogoutTime(autoLogoutTime);
		currentLoginInfo.setLoggedIn(true);
		currentLoginInfo.setUserInfo(loginInfo.getUserInfo());
		currentLoginInfo.setDimensions(loginInfo.getDimensions());
		currentLoginInfo.setCustomDimensionsDescriptionAr(loginInfo.getCustomDimensionsDescriptionAr());
		currentLoginInfo.setCustomDimensionsDescriptionEn(loginInfo.getCustomDimensionsDescriptionEn());
		currentLoginInfo.setMenu(loginInfo.getMenu());
		currentLoginInfo.setpHash(pHash);
		currentLoginInfo.setLastNotification((long) 0);
		currentLoginInfo.setDefaultSettings(defaultSettings);
		currentLoginInfo.setDeviceId(deviceId);
		currentLoginInfo.setPreferedLanguage(loginInfo.getPreferedLanguage());
		currentLoginInfo.setAllowedEntities(loginInfo.getAllowedEntities());
		currentLoginInfo.setAllowedFeatures(loginInfo.getAllowedFeatures());
		currentLoginInfo.setUserPreventedEntities(loginInfo.getUserPreventedEntities());
		currentLoginInfo.setUserPreventedFeatures(loginInfo.getUserPreventedFeatures());
		currentLoginInfo.setShortCuts(loginInfo.getShortCuts());
		currentLoginInfo.setDefinedGUIActions(guiActions);
		currentLoginInfo.setBarCodeOn(loginInfo.getBarCodeOn());
		currentLoginInfo.setHijriDate(loginInfo.getHijriDate());
		currentLoginInfo.setAlwaysPrint1InBarcode(loginInfo.getAlwaysPrint1InBarcode());
		currentLoginInfo.setDirectPrint(loginInfo.getDirectPrint());
		currentLoginInfo.setTimedQuery(loginInfo.getTimedQuery());
		currentLoginInfo.setTimedQueryDelayInSeconds(loginInfo.getTimedQueryDelayInSeconds());
		currentLoginInfo.setMobileVerificationCodeOn(loginInfo.getMobileVerificationCodeOn());
		currentLoginInfo.setOtpId(loginInfo.getOtpId());
		return currentLoginInfo;
	}

	public static CurrentLoginInfo notLoggedIn()
	{
		CurrentLoginInfo currentLoginInfo = new CurrentLoginInfo();
		currentLoginInfo.setLoggedIn(false);
		return currentLoginInfo;
	}

	public Long getLastNotification()
	{
		return lastNotification;
	}

	public void setLastNotification(Long lastNotification)
	{
		this.lastNotification = lastNotification;
	}

	public String getDeviceId()
	{
		return deviceId;
	}

	public void setDeviceId(String deviceId)
	{
		this.deviceId = deviceId;
	}

	public SettingsDTO getDefaultSettings()
	{
		return defaultSettings;
	}

	public void setDefaultSettings(SettingsDTO defaultSettings)
	{
		this.defaultSettings = defaultSettings;
	}

	public EntityDimensionsDTO getDimensions()
	{
		return dimensions;
	}

	public void setDimensions(EntityDimensionsDTO dimensions)
	{
		this.dimensions = dimensions;
	}

	@XmlTransient
	public boolean isLegalEntitySelected()
	{
		return ObjectChecker.isNotEmptyOrNull(getDimensions());
	}

	public Language getPreferedLanguage()
	{
		return preferedLanguage;
	}

	public void setPreferedLanguage(Language preferedLanguage)
	{
		this.preferedLanguage = preferedLanguage;
	}

	public List<String> getAllowedEntities()
	{
		return allowedEntities;
	}

	public void setAllowedEntities(List<String> allowedEntities)
	{
		this.allowedEntities = allowedEntities;
	}

	public List<String> getAllowedFeatures()
	{
		return allowedFeatures;
	}

	public void setAllowedFeatures(List<String> allowedFeatures)
	{
		this.allowedFeatures = allowedFeatures;
	}

	public List<String> getUserPreventedEntities()
	{
		return userPreventedEntities;
	}

	public void setUserPreventedEntities(List<String> userPreventedEntities)
	{
		this.userPreventedEntities = userPreventedEntities;
	}

	public List<String> getUserPreventedFeatures()
	{
		return userPreventedFeatures;
	}

	public void setUserPreventedFeatures(List<String> userPreventedFeatures)
	{
		this.userPreventedFeatures = userPreventedFeatures;
	}

	public DTOShortCutsDefinition getShortCuts()
	{
		return shortCuts;
	}

	public void setShortCuts(DTOShortCutsDefinition shortCuts)
	{
		this.shortCuts = shortCuts;
	}

	public List<String> getDefinedGUIActions()
	{
		return definedGUIActions;
	}

	public void setDefinedGUIActions(List<String> definedGUIActions)
	{
		this.definedGUIActions = definedGUIActions;
	}

	public Boolean getBarCodeOn()
	{
		return barCodeOn;
	}

	public void setBarCodeOn(Boolean barCodeOn)
	{
		this.barCodeOn = ObjectChecker.isTrue(barCodeOn);
	}

	public Boolean getAlwaysPrint1InBarcode()
	{
		return alwaysPrint1InBarcode;
	}

	public void setAlwaysPrint1InBarcode(Boolean alwaysPrint1InBarcode)
	{
		this.alwaysPrint1InBarcode = ObjectChecker.isTrue(alwaysPrint1InBarcode);
	}

	public Boolean getDirectPrint()
	{
		return directPrint;
	}

	public void setDirectPrint(Boolean directPrint)
	{
		this.directPrint = ObjectChecker.isTrue(directPrint);
	}

	public EntityReferenceData getTimedQuery()
	{
		return timedQuery;
	}

	public void setTimedQuery(EntityReferenceData timedQuery)
	{
		this.timedQuery = timedQuery;
	}

	public Long getTimedQueryDelayInSeconds()
	{
		return timedQueryDelayInSeconds;
	}

	public void setTimedQueryDelayInSeconds(Long timedQueryDelayInSeconds)
	{
		this.timedQueryDelayInSeconds = timedQueryDelayInSeconds;
	}

	public Boolean getHijriDate()
	{
		if (hijriDate == null)
			hijriDate = false;
		return hijriDate;
	}

	public void setHijriDate(Boolean hijriDate)
	{
		this.hijriDate = hijriDate;
	}

	public Integer getAutoLogoutTime()
	{
		return autoLogoutTime;
	}

	public void setAutoLogoutTime(Integer autoLogoutTime)
	{
		this.autoLogoutTime = autoLogoutTime;
	}

	public Boolean getAutoLogoutRememberMe()
	{
		return autoLogoutRememberMe;
	}

	public void setAutoLogoutRememberMe(Boolean autoLogoutRememberMe)
	{
		this.autoLogoutRememberMe = autoLogoutRememberMe;
	}

	public DTOUserFavourites getFavourites()
	{
		return favourites;
	}

	public void setFavourites(DTOUserFavourites favourites)
	{
		this.favourites = favourites;
	}

	public Boolean getMobileVerificationCodeOn()
	{
		return mobileVerificationCodeOn;
	}

	public void setMobileVerificationCodeOn(Boolean mobileVerificationCodeOn)
	{
		this.mobileVerificationCodeOn = mobileVerificationCodeOn;
	}

	public String getCustomDimensionsDescriptionAr()
	{
		return customDimensionsDescriptionAr;
	}

	public void setCustomDimensionsDescriptionAr(String customDimensionsDescriptionAr)
	{
		this.customDimensionsDescriptionAr = customDimensionsDescriptionAr;
	}

	public String getCustomDimensionsDescriptionEn()
	{
		return customDimensionsDescriptionEn;
	}

	public void setCustomDimensionsDescriptionEn(String customDimensionsDescriptionEn)
	{
		this.customDimensionsDescriptionEn = customDimensionsDescriptionEn;
	}

	public String getOtpId()
	{
		return otpId;
	}

	public void setOtpId(String otpId)
	{
		this.otpId = otpId;
	}
}
