package com.namasoft.contracts.common.dtos;

import com.namasoft.common.utilities.*;

import java.io.Serializable;
import java.util.*;
import java.util.stream.*;

public class DTODashBoardResultSet implements Serializable
{
	private static final long serialVersionUID = -9183312842125504824L;
	private List<DTODashBoardResultSetRow> rows = new ArrayList<>();
	private Map<String, String> agColumnCellDataTypes = new HashMap<>();

	public DTODashBoardResultSet()
	{

	}

	public DTODashBoardResultSet(List<List<String>> resultSet)
	{
		if (ObjectChecker.isEmptyOrNull(resultSet))
		{
			resultSet = new ArrayList<>();
			resultSet.add(new ArrayList<>());
		}
		for (List<String> data : resultSet)
		{
			this.rows.add(new DTODashBoardResultSetRow(data));
		}

	}

	public void addRows(List<List<String>> resultSet)
	{
		if (ObjectChecker.isEmptyOrNull(resultSet))
		{
			resultSet = new ArrayList<>();
			resultSet.add(new ArrayList<>());
		}
		for (List<String> data : resultSet)
		{
			this.rows.add(new DTODashBoardResultSetRow(data));
		}
	}

	public List<DTODashBoardResultSetRow> getRows()
	{
		return rows;
	}

	public void setRows(List<DTODashBoardResultSetRow> rows)
	{
		this.rows = rows;
	}

	public List<String> getHeadrNames()
	{
		return rows.get(0).getValues();
	}

	public int size()
	{
		return rows.size() - 1;
	}

	public List<String> get(int i)
	{
		if (i + 1 >= rows.size())
			return new ArrayList<String>();
		return rows.get(i + 1).getValues();
	}

	public String get(int row, int column)
	{
		return get(row).get(column);
	}

	public String get(int row, String column)
	{
		int index = rows.get(0).indexOf(column);
		if (index < 0)
			return "";
		return get(row, index);
	}

	public Double getAsDouble(int i, String columnName)
	{
		String strVale = get(i, columnName);
		try
		{
			return Double.parseDouble(strVale);
		}
		catch (Exception e)
		{
			return 0.0;
		}
	}

	public List<String> geCSVColumns(int row, String csvColumnNames)
	{
		List<String> columnNames = StringUtils.csvLineToList(csvColumnNames);
		List<String> values = new ArrayList<String>();
		for (String columnName : columnNames)
		{
			values.add(get(row, columnName));
		}
		return values;
	}

	public List<String> collectDistinctParameterValues(String columnName)
	{
		return IntStream.range(0, size()).mapToObj(i -> get(i, columnName)).distinct().collect(Collectors.toList());
	}

	public Map<String, String> getAgColumnCellDataTypes()
	{
		return agColumnCellDataTypes;
	}

	public void setAgColumnCellDataTypes(Map<String, String> agColumnCellDataTypes)
	{
		this.agColumnCellDataTypes = agColumnCellDataTypes;
	}
}