package com.namasoft.contracts.common.dtos;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTODocumentBookInfo;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTODocumentBook extends MasterFileDTO
{
	private String documentType;
	private String altCode;
	private DTOAutoCodingParams autoCodingParams;
	private Boolean systemBookOrTerm;
	private Boolean inActive;
	private Boolean printOnSave;
	private Integer systemSuffixLength;
	private EntityReferenceData filters;
	private EntityReferenceData template;
	private DTODocumentBookInfo bookInfo;
	public String getDocumentType()
	{
		return documentType;
	}

	public void setDocumentType(String documentType)
	{
		this.documentType = documentType;
	}

	public String getAltCode()
	{
		return altCode;
	}

	public void setAltCode(String altCode)
	{
		this.altCode = altCode;
	}

	public DTOAutoCodingParams getAutoCodingParams()
	{
		return autoCodingParams;
	}

	public void setAutoCodingParams(DTOAutoCodingParams autoCodingParams)
	{
		this.autoCodingParams = autoCodingParams;
	}

	public Integer getSystemSuffixLength()
	{
		return systemSuffixLength;
	}

	public void setSystemSuffixLength(Integer systemSuffixLength)
	{
		this.systemSuffixLength = systemSuffixLength;
	}

	public Boolean getSystemBookOrTerm()
	{
		return systemBookOrTerm;
	}

	public void setSystemBookOrTerm(Boolean systemBookOrTerm)
	{
		this.systemBookOrTerm = systemBookOrTerm;
	}

	public Boolean getPrintOnSave()
	{
		return printOnSave;
	}

	public void setPrintOnSave(Boolean printOnSave)
	{
		this.printOnSave = printOnSave;
	}

	public Boolean getInActive()
	{
		return inActive;
	}

	public void setInActive(Boolean inActive)
	{
		this.inActive = inActive;
	}

	public EntityReferenceData getFilters()
	{
		return filters;
	}

	public void setFilters(EntityReferenceData filters)
	{
		this.filters = filters;
	}

	public EntityReferenceData getTemplate()
	{
		return template;
	}

	public void setTemplate(EntityReferenceData template)
	{
		this.template = template;
	}

	public DTODocumentBookInfo getBookInfo()
	{
		return bookInfo;
	}

	public void setBookInfo(DTODocumentBookInfo bookInfo)
	{
		this.bookInfo = bookInfo;
	}

	@Override
	public String fetchDocTypeOrForTypeForBook_Term_Group()
	{
		return documentType;
	}
}
