package com.namasoft.contracts.common.dtos;

import java.math.BigDecimal;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.flatobjects.EntityReferenceData;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOMoney extends NaMaDTO
{
	private BigDecimal amount;
	private EntityReferenceData currency;

	public BigDecimal getAmount()
	{
		return amount;
	}

	public void setAmount(BigDecimal amount)
	{
		this.amount = amount;
	}

	public EntityReferenceData getCurrency()
	{
		return currency;
	}

	public void setCurrency(EntityReferenceData currency)
	{
		this.currency = currency;
	}

	public void addAmount(BigDecimal value)
	{
		if(getAmount()==null)
			setAmount(new BigDecimal(0));
		setAmount(getAmount().add(value));		
	}

}
