package com.namasoft.contracts.common.dtos;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTONaMaLayout extends DTONaMaFileSystemInfo implements Serializable
{
	private byte[] fileContent;

	public byte[] getFileContent()
	{
		return fileContent;
	}

	public void setFileContent(byte[] fileContent)
	{
		this.fileContent = fileContent;
	}

	public String contentAsString()
	{
		return byteArrayToString(getFileContent());
	}

	public static String byteArrayToString(byte[] data)
	{
		try
		{
			byte[] byteArrContent = data;
			String strContent = "";
			if (byteArrContent != null && byteArrContent.length > 0)
				strContent = new String(byteArrContent, "UTF-8");
			return strContent;
		}
		catch (UnsupportedEncodingException e)
		{
			throw new RuntimeException(e);
		}
	}

	public void contentAsString(String content)
	{
		setFileContent(stringToByteArray(content));
	}

	public static byte[] stringToByteArray(String content)
	{
		try
		{
			return content.getBytes("UTF-8");
		}
		catch (UnsupportedEncodingException e)
		{
			throw new RuntimeException(e);
		}
	}

}
