package com.namasoft.contracts.common.dtos;

import java.math.BigDecimal;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.constants.TimePeriodType;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOTimePeriod extends NaMaDTO
{
	private BigDecimal value;
	private String uom;

	public BigDecimal getValue()
	{
		return value;
	}

	public String getUom()
	{
		return uom;
	}

	public void setUom(String uom)
	{
		this.uom = uom;
	}

	public void setValue(BigDecimal value)
	{
		this.value = value;
	}
	
	public static DTOTimePeriod ofMonths(long value)
	{
		DTOTimePeriod dto = new DTOTimePeriod();
		dto.setUom(TimePeriodType.Month.toString());
		dto.setValue(BigDecimal.valueOf(value));
		return dto;
	}

}
