package com.namasoft.contracts.common.dtos;

import com.namasoft.common.layout.metadata.CustomRepInfo;
import com.namasoft.common.utilities.ObjectChecker;

import java.io.Serializable;
import java.util.*;

@SuppressWarnings("serial")
public class DTOUserDashbordChartLine implements Serializable
{
	private String chartType;
	private String arChartTitle;
	private String enChartTitle;
	private int totalCols;
	private int totalRows;
	private int rowNumber;
	private int colNumber;
	private DTODashBoardResultSet resultSet;
	private HashMap<String, String> parameters;
	private long refreshPer;
	private String widgetId;
	private CustomRepInfo repoInfo;
	private String groupCode;
	private String groupName1;
	private String groupName2;
	private DTOStackAndGroupedColData stackAndGroupedColData;
	private List<DTOCardMenuLine> cardMenu;
	private List<DTOMetricsCardLine> metricsCards;
	private List<DTOTimelineData> timeLineData;
	private Boolean horizontalMode;

	public DTOStackAndGroupedColData getStackAndGroupedColData()
	{
		return stackAndGroupedColData;
	}

	public void setStackAndGroupedColData(DTOStackAndGroupedColData stackAndGroupedColData)
	{
		this.stackAndGroupedColData = stackAndGroupedColData;
	}

	public String getChartType()
	{
		return chartType;
	}

	public void setChartType(String chartType)
	{
		this.chartType = chartType;
	}

	public String getArChartTitle()
	{
		return arChartTitle;
	}

	public void setArChartTitle(String arChartTitle)
	{
		this.arChartTitle = arChartTitle;
	}

	public String getEnChartTitle()
	{
		return enChartTitle;
	}

	public void setEnChartTitle(String enChartTitle)
	{
		this.enChartTitle = enChartTitle;
	}

	public int getCols()
	{
		return totalCols;
	}

	public void setCols(int cols)
	{
		this.totalCols = cols;
	}

	public int getRows()
	{
		return totalRows;
	}

	public void setRows(int rows)
	{
		this.totalRows = rows;
	}

	public int getRowNumber()
	{
		return rowNumber;
	}

	public void setRowNumber(int rowNumber)
	{
		this.rowNumber = rowNumber;
	}

	public int getColNumber()
	{
		return colNumber;
	}

	public void setColNumber(int colNumber)
	{
		this.colNumber = colNumber;
	}

	public DTODashBoardResultSet getResultSet()
	{
		return resultSet;
	}

	public void setResultSet(DTODashBoardResultSet values)
	{
		this.resultSet = values;
	}

	public HashMap<String, String> getParameters()
	{
		return parameters;
	}

	public void setParameters(HashMap<String, String> parameters)
	{
		this.parameters = parameters;
	}

	public long getRefreshPer()
	{
		return refreshPer;
	}

	public void setRefreshPer(long refreshPer)
	{
		this.refreshPer = refreshPer;
	}

	public String getWidgetId()
	{
		return widgetId;
	}

	public void setWidgetId(String widgetId)
	{
		this.widgetId = widgetId;
	}

	public String getByParameterName(int i, String paramName)
	{
		return getResultSet().get(i, getParameters().get(paramName));
	}

	public CustomRepInfo getRepoInfo()
	{
		return repoInfo;
	}

	public void setRepoInfo(CustomRepInfo repoInfo)
	{
		this.repoInfo = repoInfo;
	}

	public String getGroupCode()
	{
		return groupCode;
	}

	public void setGroupCode(String groupCode)
	{
		this.groupCode = groupCode;
	}

	public String getGroupName1()
	{
		return groupName1;
	}

	public void setGroupName1(String groupName1)
	{
		this.groupName1 = groupName1;
	}

	public String getGroupName2()
	{
		return groupName2;
	}

	public void setGroupName2(String groupName2)
	{
		this.groupName2 = groupName2;
	}

	public String calcChartTitle(boolean isArabic)
	{
		if (isArabic)
			return ObjectChecker.toStringOrEmpty(getArChartTitle());
		return ObjectChecker.toStringOrEmpty(getEnChartTitle());
	}

	public List<DTOCardMenuLine> getCardMenu()
	{
		return cardMenu;
	}

	public void setCardMenu(List<DTOCardMenuLine> cardMenu)
	{
		this.cardMenu = cardMenu;
	}

	public List<DTOMetricsCardLine> getMetricsCards()
	{
		return metricsCards;
	}

	public void setMetricsCards(List<DTOMetricsCardLine> metricsCards)
	{
		this.metricsCards = metricsCards;
	}

	public List<DTOTimelineData> getTimeLineData()
	{
		return timeLineData;
	}

	public void setTimeLineData(List<DTOTimelineData> timeLineData)
	{
		this.timeLineData = timeLineData;
	}

	public Boolean getHorizontalMode()
	{
		return horizontalMode;
	}

	public void setHorizontalMode(Boolean horizontalMode)
	{
		this.horizontalMode = horizontalMode;
	}
}
