package com.namasoft.contracts.common.dtos;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.modules.commonbasic.contracts.requests.DTODocumentRequestStatuses;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.util.Date;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class DocumentFileDTO extends BaseEntityDTO
{
	private EntityReferenceData book;
	private EntityReferenceData term;
	private EntityReferenceData fiscalYear;
	private EntityReferenceData fiscalPeriod;
	private Date issueDate;
	private Date valueDate;
	private EntityReferenceData fromDoc;
	private EntityReferenceData rbook;
	private EntityReferenceData rpaper;
	private DTODocumentRequestStatuses requests;
	private String manualRef1;
	private Boolean preventUseAsFromDoc;
	private Boolean guessFiscalPeriodAndYearIfNeeded;
	private Integer fromDocsCount;
	private EntityReferenceData openShift;
	protected DocumentFileDTO()
	{
		super();
	}

	protected DocumentFileDTO(String entityType)
	{
		super(entityType);
	}

	public EntityReferenceData getBook()
	{
		return book;
	}

	public void setBook(EntityReferenceData book)
	{
		this.book = book;
	}

	public EntityReferenceData getTerm()
	{
		return term;
	}

	public void setTerm(EntityReferenceData term)
	{
		this.term = term;
	}

	public EntityReferenceData getFiscalYear()
	{
		return fiscalYear;
	}

	public void setFiscalYear(EntityReferenceData fiscalYear)
	{
		this.fiscalYear = fiscalYear;
	}

	public EntityReferenceData getFiscalPeriod()
	{
		return fiscalPeriod;
	}

	public void setFiscalPeriod(EntityReferenceData fiscalPeriod)
	{
		this.fiscalPeriod = fiscalPeriod;
	}

	public Date getIssueDate()
	{
		return issueDate;
	}

	public void setIssueDate(Date issueDate)
	{
		this.issueDate = issueDate;
	}

	public Date getValueDate()
	{
		return valueDate;
	}

	public void setValueDate(Date valueDate)
	{
		this.valueDate = valueDate;
	}

	public EntityReferenceData getFromDoc()
	{
		return fromDoc;
	}

	public void setFromDoc(EntityReferenceData fromDoc)
	{
		this.fromDoc = fromDoc;
	}

	public DTODocumentRequestStatuses getRequests()
	{
		return requests;
	}

	public void setRequests(DTODocumentRequestStatuses requests)
	{
		this.requests = requests;
	}

	public String getManualRef1()
	{
		return manualRef1;
	}

	public void setManualRef1(String manualRef1)
	{
		this.manualRef1 = manualRef1;
	}

	public EntityReferenceData toRef()
	{
		return new EntityReferenceData(getEntityType(), getId(), getCode(), getValueDate());
	}
	public void setRbook(EntityReferenceData receiptBook)
	{
		this.rbook = receiptBook;
	}

	public void setRpaper(EntityReferenceData receiptPaper)
	{
		this.rpaper = receiptPaper;
	}

	public EntityReferenceData getRbook()
	{
		return rbook;
	}

	public EntityReferenceData getRpaper()
	{
		return rpaper;
	}

	public Boolean getPreventUseAsFromDoc()
	{
		return preventUseAsFromDoc;
	}

	public void setPreventUseAsFromDoc(Boolean preventUseAsFromDoc)
	{
		this.preventUseAsFromDoc = preventUseAsFromDoc;
	}

	public Integer getFromDocsCount()
	{
		return fromDocsCount;
	}

	public void setFromDocsCount(Integer fromDocsCount)
	{
		this.fromDocsCount = fromDocsCount;
	}

	public EntityReferenceData getOpenShift()
	{
		return openShift;
	}

	public void setOpenShift(EntityReferenceData openShift)
	{
		this.openShift = openShift;
	}

	public EntityReferenceData toEntityReferenceData()
	{
		return new EntityReferenceData(getEntityType(), getId(), getCode(), getValueDate());
	}

	public Boolean getGuessFiscalPeriodAndYearIfNeeded()
	{
		return guessFiscalPeriodAndYearIfNeeded;
	}

	public void setGuessFiscalPeriodAndYearIfNeeded(Boolean guessFiscalPeriodAndYearIfNeeded)
	{
		this.guessFiscalPeriodAndYearIfNeeded = guessFiscalPeriodAndYearIfNeeded;
	}
}